# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AllowedIpRangeResponse',
    'DatabaseConfigResponse',
    'EncryptionConfigResponse',
    'EnvironmentConfigResponse',
    'IPAllocationPolicyResponse',
    'MaintenanceWindowResponse',
    'NodeConfigResponse',
    'PrivateClusterConfigResponse',
    'PrivateEnvironmentConfigResponse',
    'SoftwareConfigResponse',
    'WebServerConfigResponse',
    'WebServerNetworkAccessControlResponse',
]

@pulumi.output_type
class AllowedIpRangeResponse(dict):
    """
    Allowed IP range with user-provided description.
    """
    def __init__(__self__, *,
                 description: str,
                 value: str):
        """
        Allowed IP range with user-provided description.
        :param str description: Optional. User-provided description. It must contain at most 300 characters.
        :param str value: IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32` or `2001:0db8:0000:0042:0000:8a2e:0370:7334`. IP range prefixes should be properly truncated. For example, `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` should be truncated to `2001:db8::/32`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User-provided description. It must contain at most 300 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32` or `2001:0db8:0000:0042:0000:8a2e:0370:7334`. IP range prefixes should be properly truncated. For example, `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` should be truncated to `2001:db8::/32`.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseConfigResponse(dict):
    """
    The configuration of Cloud SQL instance that is used by the Apache Airflow software.
    """
    def __init__(__self__, *,
                 machine_type: str):
        """
        The configuration of Cloud SQL instance that is used by the Apache Airflow software.
        :param str machine_type: Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        return pulumi.get(self, "machine_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EncryptionConfigResponse(dict):
    """
    The encryption options for the Composer environment and its dependencies.
    """
    def __init__(__self__, *,
                 kms_key_name: str):
        """
        The encryption options for the Composer environment and its dependencies.
        :param str kms_key_name: Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated. If not specified, Google-managed key will be used.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated. If not specified, Google-managed key will be used.
        """
        return pulumi.get(self, "kms_key_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EnvironmentConfigResponse(dict):
    """
    Configuration information for an environment.
    """
    def __init__(__self__, *,
                 airflow_uri: str,
                 dag_gcs_prefix: str,
                 database_config: 'outputs.DatabaseConfigResponse',
                 encryption_config: 'outputs.EncryptionConfigResponse',
                 gke_cluster: str,
                 maintenance_window: 'outputs.MaintenanceWindowResponse',
                 node_config: 'outputs.NodeConfigResponse',
                 node_count: int,
                 private_environment_config: 'outputs.PrivateEnvironmentConfigResponse',
                 software_config: 'outputs.SoftwareConfigResponse',
                 web_server_config: 'outputs.WebServerConfigResponse',
                 web_server_network_access_control: 'outputs.WebServerNetworkAccessControlResponse'):
        """
        Configuration information for an environment.
        :param str airflow_uri: The URI of the Apache Airflow Web UI hosted within this environment (see [Airflow web interface](/composer/docs/how-to/accessing/airflow-web-interface)).
        :param str dag_gcs_prefix: The Cloud Storage prefix of the DAGs for this environment. Although Cloud Storage objects reside in a flat namespace, a hierarchical file tree can be simulated using "/"-delimited object name prefixes. DAG objects for this environment reside in a simulated directory with the given prefix.
        :param 'DatabaseConfigResponseArgs' database_config: Optional. The configuration settings for Cloud SQL instance used internally by Apache Airflow software.
        :param 'EncryptionConfigResponseArgs' encryption_config: Optional. The encryption options for the Composer environment and its dependencies. Cannot be updated.
        :param str gke_cluster: The Kubernetes Engine cluster used to run this environment.
        :param 'MaintenanceWindowResponseArgs' maintenance_window: Optional. The maintenance window is the period when Cloud Composer components may undergo maintenance. It is defined so that maintenance is not executed during peak hours or critical time periods. The system will not be under maintenance for every occurrence of this window, but when maintenance is planned, it will be scheduled during the window. The maintenance window period must encompass at least 12 hours per week. This may be split into multiple chunks, each with a size of at least 4 hours. If this value is omitted, Cloud Composer components may be subject to maintenance at any time.
        :param 'NodeConfigResponseArgs' node_config: The configuration used for the Kubernetes Engine cluster.
        :param int node_count: The number of nodes in the Kubernetes Engine cluster that will be used to run this environment.
        :param 'PrivateEnvironmentConfigResponseArgs' private_environment_config: The configuration used for the Private IP Cloud Composer environment.
        :param 'SoftwareConfigResponseArgs' software_config: The configuration settings for software inside the environment.
        :param 'WebServerConfigResponseArgs' web_server_config: Optional. The configuration settings for the Airflow web server App Engine instance.
        :param 'WebServerNetworkAccessControlResponseArgs' web_server_network_access_control: Optional. The network-level access control policy for the Airflow web server. If unspecified, no network-level access restrictions will be applied.
        """
        pulumi.set(__self__, "airflow_uri", airflow_uri)
        pulumi.set(__self__, "dag_gcs_prefix", dag_gcs_prefix)
        pulumi.set(__self__, "database_config", database_config)
        pulumi.set(__self__, "encryption_config", encryption_config)
        pulumi.set(__self__, "gke_cluster", gke_cluster)
        pulumi.set(__self__, "maintenance_window", maintenance_window)
        pulumi.set(__self__, "node_config", node_config)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "private_environment_config", private_environment_config)
        pulumi.set(__self__, "software_config", software_config)
        pulumi.set(__self__, "web_server_config", web_server_config)
        pulumi.set(__self__, "web_server_network_access_control", web_server_network_access_control)

    @property
    @pulumi.getter(name="airflowUri")
    def airflow_uri(self) -> str:
        """
        The URI of the Apache Airflow Web UI hosted within this environment (see [Airflow web interface](/composer/docs/how-to/accessing/airflow-web-interface)).
        """
        return pulumi.get(self, "airflow_uri")

    @property
    @pulumi.getter(name="dagGcsPrefix")
    def dag_gcs_prefix(self) -> str:
        """
        The Cloud Storage prefix of the DAGs for this environment. Although Cloud Storage objects reside in a flat namespace, a hierarchical file tree can be simulated using "/"-delimited object name prefixes. DAG objects for this environment reside in a simulated directory with the given prefix.
        """
        return pulumi.get(self, "dag_gcs_prefix")

    @property
    @pulumi.getter(name="databaseConfig")
    def database_config(self) -> 'outputs.DatabaseConfigResponse':
        """
        Optional. The configuration settings for Cloud SQL instance used internally by Apache Airflow software.
        """
        return pulumi.get(self, "database_config")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> 'outputs.EncryptionConfigResponse':
        """
        Optional. The encryption options for the Composer environment and its dependencies. Cannot be updated.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="gkeCluster")
    def gke_cluster(self) -> str:
        """
        The Kubernetes Engine cluster used to run this environment.
        """
        return pulumi.get(self, "gke_cluster")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> 'outputs.MaintenanceWindowResponse':
        """
        Optional. The maintenance window is the period when Cloud Composer components may undergo maintenance. It is defined so that maintenance is not executed during peak hours or critical time periods. The system will not be under maintenance for every occurrence of this window, but when maintenance is planned, it will be scheduled during the window. The maintenance window period must encompass at least 12 hours per week. This may be split into multiple chunks, each with a size of at least 4 hours. If this value is omitted, Cloud Composer components may be subject to maintenance at any time.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> 'outputs.NodeConfigResponse':
        """
        The configuration used for the Kubernetes Engine cluster.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes in the Kubernetes Engine cluster that will be used to run this environment.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="privateEnvironmentConfig")
    def private_environment_config(self) -> 'outputs.PrivateEnvironmentConfigResponse':
        """
        The configuration used for the Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_environment_config")

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> 'outputs.SoftwareConfigResponse':
        """
        The configuration settings for software inside the environment.
        """
        return pulumi.get(self, "software_config")

    @property
    @pulumi.getter(name="webServerConfig")
    def web_server_config(self) -> 'outputs.WebServerConfigResponse':
        """
        Optional. The configuration settings for the Airflow web server App Engine instance.
        """
        return pulumi.get(self, "web_server_config")

    @property
    @pulumi.getter(name="webServerNetworkAccessControl")
    def web_server_network_access_control(self) -> 'outputs.WebServerNetworkAccessControlResponse':
        """
        Optional. The network-level access control policy for the Airflow web server. If unspecified, no network-level access restrictions will be applied.
        """
        return pulumi.get(self, "web_server_network_access_control")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IPAllocationPolicyResponse(dict):
    """
    Configuration for controlling how IPs are allocated in the GKE cluster.
    """
    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: str,
                 cluster_secondary_range_name: str,
                 services_ipv4_cidr_block: str,
                 services_secondary_range_name: str,
                 use_ip_aliases: bool):
        """
        Configuration for controlling how IPs are allocated in the GKE cluster.
        :param str cluster_ipv4_cidr_block: Optional. The IP address range used to allocate IP addresses to pods in the cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both.
        :param str cluster_secondary_range_name: Optional. The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        :param str services_ipv4_cidr_block: Optional. The IP address range of the services IP addresses in this cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `services_secondary_range_name` or `services_ipv4_cidr_block` but not both.
        :param str services_secondary_range_name: Optional. The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either `services_secondary_range_name` or `services_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        :param bool use_ip_aliases: Optional. Whether or not to enable Alias IPs in the GKE cluster. If `true`, a VPC-native cluster is created.
        """
        pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> str:
        """
        Optional. The IP address range used to allocate IP addresses to pods in the cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> str:
        """
        Optional. The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> str:
        """
        Optional. The IP address range of the services IP addresses in this cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `services_secondary_range_name` or `services_ipv4_cidr_block` but not both.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> str:
        """
        Optional. The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either `services_secondary_range_name` or `services_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> bool:
        """
        Optional. Whether or not to enable Alias IPs in the GKE cluster. If `true`, a VPC-native cluster is created.
        """
        return pulumi.get(self, "use_ip_aliases")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MaintenanceWindowResponse(dict):
    """
    The configuration settings for Cloud Composer maintenance window. The following example: { "startTime":"2019-08-01T01:00:00Z" "endTime":"2019-08-01T07:00:00Z" "recurrence":"FREQ=WEEKLY;BYDAY=TU,WE" } would define a maintenance window between 01 and 07 hours UTC during each Tuesday and Wednesday.
    """
    def __init__(__self__, *,
                 end_time: str,
                 recurrence: str,
                 start_time: str):
        """
        The configuration settings for Cloud Composer maintenance window. The following example: { "startTime":"2019-08-01T01:00:00Z" "endTime":"2019-08-01T07:00:00Z" "recurrence":"FREQ=WEEKLY;BYDAY=TU,WE" } would define a maintenance window between 01 and 07 hours UTC during each Tuesday and Wednesday.
        :param str end_time: Required. Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end_time must be in the future, relative to `start_time`.
        :param str recurrence: Required. Maintenance window recurrence. Format is a subset of [RFC-5545](https://tools.ietf.org/html/rfc5545) `RRULE`. The only allowed values for `FREQ` field are `FREQ=DAILY` and `FREQ=WEEKLY;BYDAY=...` Example values: `FREQ=WEEKLY;BYDAY=TU,WE`, `FREQ=DAILY`.
        :param str start_time: Required. Start time of the first recurrence of the maintenance window.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Required. Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end_time must be in the future, relative to `start_time`.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        """
        Required. Maintenance window recurrence. Format is a subset of [RFC-5545](https://tools.ietf.org/html/rfc5545) `RRULE`. The only allowed values for `FREQ` field are `FREQ=DAILY` and `FREQ=WEEKLY;BYDAY=...` Example values: `FREQ=WEEKLY;BYDAY=TU,WE`, `FREQ=DAILY`.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Required. Start time of the first recurrence of the maintenance window.
        """
        return pulumi.get(self, "start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodeConfigResponse(dict):
    """
    The configuration information for the Kubernetes Engine nodes running the Apache Airflow software.
    """
    def __init__(__self__, *,
                 disk_size_gb: int,
                 ip_allocation_policy: 'outputs.IPAllocationPolicyResponse',
                 location: str,
                 machine_type: str,
                 max_pods_per_node: int,
                 network: str,
                 oauth_scopes: Sequence[str],
                 service_account: str,
                 subnetwork: str,
                 tags: Sequence[str]):
        """
        The configuration information for the Kubernetes Engine nodes running the Apache Airflow software.
        :param int disk_size_gb: Optional. The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated.
        :param 'IPAllocationPolicyResponseArgs' ip_allocation_policy: Optional. The IPAllocationPolicy fields for the GKE cluster.
        :param str location: Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which to deploy the VMs used to run the Apache Airflow software, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}". This `location` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.machineType` are specified, `nodeConfig.machineType` must belong to this `location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If only one field (`location` or `nodeConfig.machineType`) is specified, the location information from the specified field will be propagated to the unspecified field.
        :param str machine_type: Optional. The Compute Engine [machine type](/compute/docs/machine-types) used for cluster instances, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}". The `machineType` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.location` are specified, this `machineType` must belong to the `nodeConfig.location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If exactly one of this field and `nodeConfig.location` is specified, the location information from the specified field will be propagated to the unspecified field. The `machineTypeId` must not be a [shared-core machine type](/compute/docs/machine-types#sharedcore). If this field is unspecified, the `machineTypeId` defaults to "n1-standard-1".
        :param int max_pods_per_node: Optional. The maximum number of pods per node in the Cloud Composer GKE cluster. The value must be between 8 and 110 and it can be set only if the environment is VPC-native. The default value is 32. Values of this field will be propagated both to the `default-pool` node pool of the newly created GKE cluster, and to the default "Maximum Pods per Node" value which is used for newly created node pools if their value is not explicitly set during node pool creation. For more information, see [Optimizing IP address allocation] (https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr). Cannot be updated.
        :param str network: Optional. The Compute Engine network to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/global/networks/{networkId}". If unspecified, the default network in the environment's project is used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets) is provided, `nodeConfig.subnetwork` must also be provided. For [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see `nodeConfig.subnetwork`.
        :param Sequence[str] oauth_scopes: Optional. The set of Google API scopes to be made available on all node VMs. If `oauth_scopes` is empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
        :param str service_account: Optional. The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated.
        :param str subnetwork: Optional. The Compute Engine subnetwork to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}" If a subnetwork is provided, `nodeConfig.network` must also be provided, and the subnetwork must belong to the enclosing environment's project and location.
        :param Sequence[str] tags: Optional. The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Cannot be updated.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Optional. The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> 'outputs.IPAllocationPolicyResponse':
        """
        Optional. The IPAllocationPolicy fields for the GKE cluster.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which to deploy the VMs used to run the Apache Airflow software, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}". This `location` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.machineType` are specified, `nodeConfig.machineType` must belong to this `location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If only one field (`location` or `nodeConfig.machineType`) is specified, the location information from the specified field will be propagated to the unspecified field.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Optional. The Compute Engine [machine type](/compute/docs/machine-types) used for cluster instances, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}". The `machineType` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.location` are specified, this `machineType` must belong to the `nodeConfig.location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If exactly one of this field and `nodeConfig.location` is specified, the location information from the specified field will be propagated to the unspecified field. The `machineTypeId` must not be a [shared-core machine type](/compute/docs/machine-types#sharedcore). If this field is unspecified, the `machineTypeId` defaults to "n1-standard-1".
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> int:
        """
        Optional. The maximum number of pods per node in the Cloud Composer GKE cluster. The value must be between 8 and 110 and it can be set only if the environment is VPC-native. The default value is 32. Values of this field will be propagated both to the `default-pool` node pool of the newly created GKE cluster, and to the default "Maximum Pods per Node" value which is used for newly created node pools if their value is not explicitly set during node pool creation. For more information, see [Optimizing IP address allocation] (https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr). Cannot be updated.
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Optional. The Compute Engine network to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/global/networks/{networkId}". If unspecified, the default network in the environment's project is used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets) is provided, `nodeConfig.subnetwork` must also be provided. For [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see `nodeConfig.subnetwork`.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        """
        Optional. The set of Google API scopes to be made available on all node VMs. If `oauth_scopes` is empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}" If a subnetwork is provided, `nodeConfig.network` must also be provided, and the subnetwork must belong to the enclosing environment's project and location.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Optional. The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Cannot be updated.
        """
        return pulumi.get(self, "tags")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PrivateClusterConfigResponse(dict):
    """
    Configuration options for the private GKE cluster in a Cloud Composer environment.
    """
    def __init__(__self__, *,
                 enable_private_endpoint: bool,
                 master_ipv4_cidr_block: str,
                 master_ipv4_reserved_range: str):
        """
        Configuration options for the private GKE cluster in a Cloud Composer environment.
        :param bool enable_private_endpoint: Optional. If `true`, access to the public endpoint of the GKE cluster is denied.
        :param str master_ipv4_cidr_block: Optional. The CIDR block from which IPv4 range for GKE master will be reserved. If left blank, the default value of '172.16.0.0/23' is used.
        :param str master_ipv4_reserved_range: The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network.
        """
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        pulumi.set(__self__, "master_ipv4_reserved_range", master_ipv4_reserved_range)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> bool:
        """
        Optional. If `true`, access to the public endpoint of the GKE cluster is denied.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> str:
        """
        Optional. The CIDR block from which IPv4 range for GKE master will be reserved. If left blank, the default value of '172.16.0.0/23' is used.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @property
    @pulumi.getter(name="masterIpv4ReservedRange")
    def master_ipv4_reserved_range(self) -> str:
        """
        The IP range in CIDR notation to use for the hosted master network. This range is used for assigning internal IP addresses to the cluster master or set of masters and to the internal load balancer virtual IP. This range must not overlap with any other ranges in use within the cluster's network.
        """
        return pulumi.get(self, "master_ipv4_reserved_range")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PrivateEnvironmentConfigResponse(dict):
    """
    The configuration information for configuring a Private IP Cloud Composer environment.
    """
    def __init__(__self__, *,
                 cloud_sql_ipv4_cidr_block: str,
                 enable_private_environment: bool,
                 private_cluster_config: 'outputs.PrivateClusterConfigResponse',
                 web_server_ipv4_cidr_block: str,
                 web_server_ipv4_reserved_range: str):
        """
        The configuration information for configuring a Private IP Cloud Composer environment.
        :param str cloud_sql_ipv4_cidr_block: Optional. The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block
        :param bool enable_private_environment: Optional. If `true`, a Private IP Cloud Composer environment is created. If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be set to true.
        :param 'PrivateClusterConfigResponseArgs' private_cluster_config: Optional. Configuration for the private GKE cluster for a Private IP Cloud Composer environment.
        :param str web_server_ipv4_cidr_block: Optional. The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block.
        :param str web_server_ipv4_reserved_range: The IP range reserved for the tenant project's App Engine VMs.
        """
        pulumi.set(__self__, "cloud_sql_ipv4_cidr_block", cloud_sql_ipv4_cidr_block)
        pulumi.set(__self__, "enable_private_environment", enable_private_environment)
        pulumi.set(__self__, "private_cluster_config", private_cluster_config)
        pulumi.set(__self__, "web_server_ipv4_cidr_block", web_server_ipv4_cidr_block)
        pulumi.set(__self__, "web_server_ipv4_reserved_range", web_server_ipv4_reserved_range)

    @property
    @pulumi.getter(name="cloudSqlIpv4CidrBlock")
    def cloud_sql_ipv4_cidr_block(self) -> str:
        """
        Optional. The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block
        """
        return pulumi.get(self, "cloud_sql_ipv4_cidr_block")

    @property
    @pulumi.getter(name="enablePrivateEnvironment")
    def enable_private_environment(self) -> bool:
        """
        Optional. If `true`, a Private IP Cloud Composer environment is created. If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be set to true.
        """
        return pulumi.get(self, "enable_private_environment")

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> 'outputs.PrivateClusterConfigResponse':
        """
        Optional. Configuration for the private GKE cluster for a Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_cluster_config")

    @property
    @pulumi.getter(name="webServerIpv4CidrBlock")
    def web_server_ipv4_cidr_block(self) -> str:
        """
        Optional. The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block.
        """
        return pulumi.get(self, "web_server_ipv4_cidr_block")

    @property
    @pulumi.getter(name="webServerIpv4ReservedRange")
    def web_server_ipv4_reserved_range(self) -> str:
        """
        The IP range reserved for the tenant project's App Engine VMs.
        """
        return pulumi.get(self, "web_server_ipv4_reserved_range")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SoftwareConfigResponse(dict):
    """
    Specifies the selection and configuration of software inside the environment.
    """
    def __init__(__self__, *,
                 airflow_config_overrides: Mapping[str, str],
                 env_variables: Mapping[str, str],
                 image_version: str,
                 pypi_packages: Mapping[str, str],
                 python_version: str):
        """
        Specifies the selection and configuration of software inside the environment.
        :param Mapping[str, str] airflow_config_overrides: Optional. Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and must not contain an equals sign ("=") or semicolon (";"). Section and property names must not contain a period ("."). Apache Airflow configuration property names must be written in [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are [blocked](/composer/docs/concepts/airflow-configurations), and cannot be overridden.
        :param Mapping[str, str] env_variables: Optional. Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression `a-zA-Z_*`. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the following reserved names: * `AIRFLOW_HOME` * `C_FORCE_ROOT` * `CONTAINER_NAME` * `DAGS_FOLDER` * `GCP_PROJECT` * `GCS_BUCKET` * `GKE_CLUSTER_NAME` * `SQL_DATABASE` * `SQL_INSTANCE` * `SQL_PASSWORD` * `SQL_PROJECT` * `SQL_REGION` * `SQL_USER`
        :param str image_version: The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression `composer-([0-9]+\.[0-9]+\.[0-9]+|latest)-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?`. When used as input, the server also checks if the provided version is supported and denies the request for an unsupported version. The Cloud Composer portion of the version is a [semantic version](https://semver.org) or `latest`. When the patch version is omitted, the current Cloud Composer patch version is selected. When `latest` is provided instead of an explicit version number, the server replaces `latest` with the current Cloud Composer version and stores that version number in the same field. The portion of the image version that follows *airflow-* is an official Apache Airflow repository [release name](https://github.com/apache/incubator-airflow/releases). See also [Version List](/composer/docs/concepts/versioning/composer-versions).
        :param Mapping[str, str] pypi_packages: Optional. Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name such as "numpy" and values are the lowercase extras and version specifier such as "==1.12.0", "[devel,gcp_api]", or "[devel]>=1.8.2, <1.9.2". To specify a package without pinning it to a version specifier, use the empty string as the value.
        :param str python_version: Optional. The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated.
        """
        pulumi.set(__self__, "airflow_config_overrides", airflow_config_overrides)
        pulumi.set(__self__, "env_variables", env_variables)
        pulumi.set(__self__, "image_version", image_version)
        pulumi.set(__self__, "pypi_packages", pypi_packages)
        pulumi.set(__self__, "python_version", python_version)

    @property
    @pulumi.getter(name="airflowConfigOverrides")
    def airflow_config_overrides(self) -> Mapping[str, str]:
        """
        Optional. Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and must not contain an equals sign ("=") or semicolon (";"). Section and property names must not contain a period ("."). Apache Airflow configuration property names must be written in [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are [blocked](/composer/docs/concepts/airflow-configurations), and cannot be overridden.
        """
        return pulumi.get(self, "airflow_config_overrides")

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Mapping[str, str]:
        """
        Optional. Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression `a-zA-Z_*`. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the following reserved names: * `AIRFLOW_HOME` * `C_FORCE_ROOT` * `CONTAINER_NAME` * `DAGS_FOLDER` * `GCP_PROJECT` * `GCS_BUCKET` * `GKE_CLUSTER_NAME` * `SQL_DATABASE` * `SQL_INSTANCE` * `SQL_PASSWORD` * `SQL_PROJECT` * `SQL_REGION` * `SQL_USER`
        """
        return pulumi.get(self, "env_variables")

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> str:
        """
        The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression `composer-([0-9]+\.[0-9]+\.[0-9]+|latest)-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?`. When used as input, the server also checks if the provided version is supported and denies the request for an unsupported version. The Cloud Composer portion of the version is a [semantic version](https://semver.org) or `latest`. When the patch version is omitted, the current Cloud Composer patch version is selected. When `latest` is provided instead of an explicit version number, the server replaces `latest` with the current Cloud Composer version and stores that version number in the same field. The portion of the image version that follows *airflow-* is an official Apache Airflow repository [release name](https://github.com/apache/incubator-airflow/releases). See also [Version List](/composer/docs/concepts/versioning/composer-versions).
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="pypiPackages")
    def pypi_packages(self) -> Mapping[str, str]:
        """
        Optional. Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name such as "numpy" and values are the lowercase extras and version specifier such as "==1.12.0", "[devel,gcp_api]", or "[devel]>=1.8.2, <1.9.2". To specify a package without pinning it to a version specifier, use the empty string as the value.
        """
        return pulumi.get(self, "pypi_packages")

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> str:
        """
        Optional. The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated.
        """
        return pulumi.get(self, "python_version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WebServerConfigResponse(dict):
    """
    The configuration settings for the Airflow web server App Engine instance.
    """
    def __init__(__self__, *,
                 machine_type: str):
        """
        The configuration settings for the Airflow web server App Engine instance.
        :param str machine_type: Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        return pulumi.get(self, "machine_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WebServerNetworkAccessControlResponse(dict):
    """
    Network-level access control policy for the Airflow web server.
    """
    def __init__(__self__, *,
                 allowed_ip_ranges: Sequence['outputs.AllowedIpRangeResponse']):
        """
        Network-level access control policy for the Airflow web server.
        :param Sequence['AllowedIpRangeResponseArgs'] allowed_ip_ranges: A collection of allowed IP ranges with descriptions.
        """
        pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)

    @property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Sequence['outputs.AllowedIpRangeResponse']:
        """
        A collection of allowed IP ranges with descriptions.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


