# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = ['OrganizationInstance']


class OrganizationInstance(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 instances_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 peering_cidr_range: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an Apigee runtime instance. The instance is accessible from the authorized network configured on the organization. **Note:** Not supported for Apigee hybrid.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Optional. Description of the instance.
        :param pulumi.Input[str] disk_encryption_key_name: Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only. Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        :param pulumi.Input[str] display_name: Optional. Display name for the instance.
        :param pulumi.Input[str] location: Required. Compute Engine location where the instance resides.
        :param pulumi.Input[str] name: Required. Resource ID of the instance. Values must match the regular expression `^a-z{0,30}[a-z\d]$`.
        :param pulumi.Input[str] peering_cidr_range: Optional. Size of the CIDR block range that will be reserved by the instance. PAID organizations support `SLASH_16` to `SLASH_20` and defaults to `SLASH_16`. Evaluation organizations support only `SLASH_23`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['disk_encryption_key_name'] = disk_encryption_key_name
            __props__['display_name'] = display_name
            if instances_id is None and not opts.urn:
                raise TypeError("Missing required property 'instances_id'")
            __props__['instances_id'] = instances_id
            __props__['location'] = location
            __props__['name'] = name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            __props__['peering_cidr_range'] = peering_cidr_range
            __props__['created_at'] = None
            __props__['host'] = None
            __props__['last_modified_at'] = None
            __props__['port'] = None
            __props__['state'] = None
        super(OrganizationInstance, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationInstance':
        """
        Get an existing OrganizationInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["created_at"] = None
        __props__["description"] = None
        __props__["disk_encryption_key_name"] = None
        __props__["display_name"] = None
        __props__["host"] = None
        __props__["last_modified_at"] = None
        __props__["location"] = None
        __props__["name"] = None
        __props__["peering_cidr_range"] = None
        __props__["port"] = None
        __props__["state"] = None
        return OrganizationInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time the instance was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. Description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEncryptionKeyName")
    def disk_encryption_key_name(self) -> pulumi.Output[str]:
        """
        Customer Managed Encryption Key (CMEK) used for disk and volume encryption. Required for Apigee paid subscriptions only. Use the following format: `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`
        """
        return pulumi.get(self, "disk_encryption_key_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Optional. Display name for the instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Internal hostname or IP address of the Apigee endpoint used by clients to connect to the service.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[str]:
        """
        Time the instance was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        Required. Compute Engine location where the instance resides.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. Resource ID of the instance. Values must match the regular expression `^a-z{0,30}[a-z\d]$`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeringCidrRange")
    def peering_cidr_range(self) -> pulumi.Output[str]:
        """
        Optional. Size of the CIDR block range that will be reserved by the instance. PAID organizations support `SLASH_16` to `SLASH_20` and defaults to `SLASH_16`. Evaluation organizations support only `SLASH_23`.
        """
        return pulumi.get(self, "peering_cidr_range")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        Port number of the exposed Apigee endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the instance. Values other than `ACTIVE` means the resource is not ready to use.
        """
        return pulumi.get(self, "state")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

