# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['OrganizationEnvironmentTraceConfigOverride']


class OrganizationEnvironmentTraceConfigOverride(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_proxy: Optional[pulumi.Input[str]] = None,
                 environments_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 overrides_id: Optional[pulumi.Input[str]] = None,
                 sampling_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1TraceSamplingConfigArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a trace configuration override. The response contains a system-generated UUID, that can be used to view, update, or delete the configuration override. Use the List API to view the existing trace configuration overrides.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_proxy: ID of the API proxy that will have its trace configuration overridden.
        :param pulumi.Input[str] name: ID of the trace configuration override specified as a system-generated UUID.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1TraceSamplingConfigArgs']] sampling_config: Trace configuration to override.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['api_proxy'] = api_proxy
            if environments_id is None and not opts.urn:
                raise TypeError("Missing required property 'environments_id'")
            __props__['environments_id'] = environments_id
            __props__['name'] = name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            if overrides_id is None and not opts.urn:
                raise TypeError("Missing required property 'overrides_id'")
            __props__['overrides_id'] = overrides_id
            __props__['sampling_config'] = sampling_config
        super(OrganizationEnvironmentTraceConfigOverride, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationEnvironmentTraceConfigOverride',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationEnvironmentTraceConfigOverride':
        """
        Get an existing OrganizationEnvironmentTraceConfigOverride resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["api_proxy"] = None
        __props__["name"] = None
        __props__["sampling_config"] = None
        return OrganizationEnvironmentTraceConfigOverride(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiProxy")
    def api_proxy(self) -> pulumi.Output[str]:
        """
        ID of the API proxy that will have its trace configuration overridden.
        """
        return pulumi.get(self, "api_proxy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        ID of the trace configuration override specified as a system-generated UUID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samplingConfig")
    def sampling_config(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1TraceSamplingConfigResponse']:
        """
        Trace configuration to override.
        """
        return pulumi.get(self, "sampling_config")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

