# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from ._inputs import *

__all__ = ['OrganizationEnvironmentAnalyticExport']


class OrganizationEnvironmentAnalyticExport(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csv_delimiter: Optional[pulumi.Input[str]] = None,
                 datastore_name: Optional[pulumi.Input[str]] = None,
                 date_range: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1DateRangeArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environments_id: Optional[pulumi.Input[str]] = None,
                 exports_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 output_format: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Submit a data export job to be processed in the background. If the request is successful, the API returns a 201 status, a URI that can be used to retrieve the status of the export job, and the `state` value of "enqueued".

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] csv_delimiter: Optional. Delimiter used in the CSV file, if `outputFormat` is set to `csv`. Defaults to the `,` (comma) character. Supported delimiter characters include comma (`,`), pipe (`|`), and tab (`\t`).
        :param pulumi.Input[str] datastore_name: Required. Name of the preconfigured datastore.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1DateRangeArgs']] date_range: Required. Date range of the data to export.
        :param pulumi.Input[str] description: Optional. Description of the export job.
        :param pulumi.Input[str] name: Required. Display name of the export job.
        :param pulumi.Input[str] output_format: Optional. Output format of the export. Valid values include: `csv` or `json`. Defaults to `json`. Note: Configure the delimiter for CSV output using the `csvDelimiter` property.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['csv_delimiter'] = csv_delimiter
            __props__['datastore_name'] = datastore_name
            __props__['date_range'] = date_range
            __props__['description'] = description
            if environments_id is None and not opts.urn:
                raise TypeError("Missing required property 'environments_id'")
            __props__['environments_id'] = environments_id
            if exports_id is None and not opts.urn:
                raise TypeError("Missing required property 'exports_id'")
            __props__['exports_id'] = exports_id
            __props__['name'] = name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            __props__['output_format'] = output_format
            __props__['created'] = None
            __props__['error'] = None
            __props__['execution_time'] = None
            __props__['self'] = None
            __props__['state'] = None
            __props__['updated'] = None
        super(OrganizationEnvironmentAnalyticExport, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationEnvironmentAnalyticExport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationEnvironmentAnalyticExport':
        """
        Get an existing OrganizationEnvironmentAnalyticExport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["created"] = None
        __props__["datastore_name"] = None
        __props__["description"] = None
        __props__["error"] = None
        __props__["execution_time"] = None
        __props__["name"] = None
        __props__["self"] = None
        __props__["state"] = None
        __props__["updated"] = None
        return OrganizationEnvironmentAnalyticExport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Time the export job was created.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="datastoreName")
    def datastore_name(self) -> pulumi.Output[str]:
        """
        Name of the datastore that is the destination of the export job [datastore]
        """
        return pulumi.get(self, "datastore_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the export job.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output[str]:
        """
        Error is set when export fails
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> pulumi.Output[str]:
        """
        Execution time for this export job. If the job is still in progress, it will be set to the amount of time that has elapsed since`created`, in seconds. Else, it will set to (`updated` - `created`), in seconds.
        """
        return pulumi.get(self, "execution_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Display name of the export job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def self(self) -> pulumi.Output[str]:
        """
        Self link of the export job. A URI that can be used to retrieve the status of an export job. Example: `/organizations/myorg/environments/myenv/analytics/exports/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd`
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Status of the export job. Valid values include `enqueued`, `running`, `completed`, and `failed`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def updated(self) -> pulumi.Output[str]:
        """
        Time the export job was last updated.
        """
        return pulumi.get(self, "updated")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

