# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['OrganizationAnalyticDatastore']


class OrganizationAnalyticDatastore(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datastore_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1DatastoreConfigArgs']]] = None,
                 datastores_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a Datastore for an org

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1DatastoreConfigArgs']] datastore_config: Datastore Configurations.
        :param pulumi.Input[str] display_name: Required. Display name in UI
        :param pulumi.Input[str] target_type: Destination storage type. Supported types `gcs` or `bigquery`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['datastore_config'] = datastore_config
            if datastores_id is None and not opts.urn:
                raise TypeError("Missing required property 'datastores_id'")
            __props__['datastores_id'] = datastores_id
            __props__['display_name'] = display_name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            __props__['target_type'] = target_type
            __props__['create_time'] = None
            __props__['last_update_time'] = None
            __props__['org'] = None
            __props__['self'] = None
        super(OrganizationAnalyticDatastore, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationAnalyticDatastore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationAnalyticDatastore':
        """
        Get an existing OrganizationAnalyticDatastore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["create_time"] = None
        __props__["datastore_config"] = None
        __props__["display_name"] = None
        __props__["last_update_time"] = None
        __props__["org"] = None
        __props__["self"] = None
        __props__["target_type"] = None
        return OrganizationAnalyticDatastore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Datastore create time, in milliseconds since the epoch of 1970-01-01T00:00:00Z
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="datastoreConfig")
    def datastore_config(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1DatastoreConfigResponse']:
        """
        Datastore Configurations.
        """
        return pulumi.get(self, "datastore_config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Required. Display name in UI
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> pulumi.Output[str]:
        """
        Datastore last update time, in milliseconds since the epoch of 1970-01-01T00:00:00Z
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter
    def org(self) -> pulumi.Output[str]:
        """
        Organization that the datastore belongs to
        """
        return pulumi.get(self, "org")

    @property
    @pulumi.getter
    def self(self) -> pulumi.Output[str]:
        """
        Resource link of Datastore. Example: `/organizations/{org}/analytics/datastores/{uuid}`
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[str]:
        """
        Destination storage type. Supported types `gcs` or `bigquery`.
        """
        return pulumi.get(self, "target_type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

