# Generated by Django 3.0.8 on 2020-07-16 16:18

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import isc_common.fields.related


class Migration(migrations.Migration):

    dependencies = [
        ('ckk', '0230_auto_20200708_1517'),
        ('production', '0282_auto_20200714_1027'),
    ]

    operations = [
        migrations.CreateModel(
            name='Operation_def_material',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False, verbose_name='Идентификатор')),
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Дата мягкого удаления')),
                ('editing', models.BooleanField(default=True, verbose_name='Возможность редактирования')),
                ('deliting', models.BooleanField(default=True, verbose_name='Возможность удаления')),
                ('lastmodified', models.DateTimeField(db_index=True, default=django.utils.timezone.now, editable=False, verbose_name='Последнее обновление')),
                ('qty', models.DecimalField(decimal_places=4, default=0.0, max_digits=10)),
                ('edizm', isc_common.fields.related.ForeignKeyProtect(default=None, on_delete=django.db.models.deletion.PROTECT, to='ckk.Ed_izm')),
                ('material', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='ckk.Materials')),
                ('material_askon', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='ckk.Material_askon')),
                ('operation', isc_common.fields.related.ForeignKeyCascade(on_delete=django.db.models.deletion.CASCADE, to='production.Operations')),
                ('parent', isc_common.fields.related.ForeignKeyProtect(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='production.Operation_def_material')),
            ],
            options={
                'verbose_name': 'Кросс таблица',
            },
        ),
        migrations.AddConstraint(
            model_name='operation_def_material',
            constraint=models.UniqueConstraint(condition=models.Q(('material', None), ('material_askon', None)), fields=('operation',), name='Operation_def_material_unique_constraint_0'),
        ),
        migrations.AddConstraint(
            model_name='operation_def_material',
            constraint=models.UniqueConstraint(condition=models.Q(material_askon=None), fields=('material', 'operation'), name='Operation_def_material_unique_constraint_1'),
        ),
        migrations.AddConstraint(
            model_name='operation_def_material',
            constraint=models.UniqueConstraint(condition=models.Q(material=None), fields=('material_askon', 'operation'), name='Operation_def_material_unique_constraint_2'),
        ),
        migrations.AddConstraint(
            model_name='operation_def_material',
            constraint=models.UniqueConstraint(fields=('material', 'material_askon', 'operation'), name='Operation_def_material_unique_constraint_3'),
        ),
    ]
