"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRouteSpec = exports.GatewayRouteHostnameMatch = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const http_route_path_match_1 = require("./http-route-path-match");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Used to generate host name matching methods.
 *
 * @stability stable
 */
class GatewayRouteHostnameMatch {
    /**
     * The value of the host name must match the specified value exactly.
     *
     * @param name The exact host name to match on.
     * @stability stable
     */
    static exactly(name) {
        return new GatewayRouteHostnameMatchImpl({ exact: name });
    }
    /**
     * The value of the host name with the given name must end with the specified characters.
     *
     * @param suffix The specified ending characters of the host name to match on.
     * @stability stable
     */
    static endsWith(suffix) {
        return new GatewayRouteHostnameMatchImpl({ suffix });
    }
}
exports.GatewayRouteHostnameMatch = GatewayRouteHostnameMatch;
_a = JSII_RTTI_SYMBOL_1;
GatewayRouteHostnameMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRouteHostnameMatch", version: "1.139.0" };
class GatewayRouteHostnameMatchImpl extends GatewayRouteHostnameMatch {
    constructor(matchProperty) {
        super();
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            hostnameMatch: this.matchProperty,
        };
    }
}
/**
 * Used to generate specs with different protocols for a GatewayRoute.
 *
 * @stability stable
 */
class GatewayRouteSpec {
    /**
     * Creates an HTTP Based GatewayRoute.
     *
     * @param options - no http gateway route.
     * @stability stable
     */
    static http(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpGatewayRouteSpecOptions(options);
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP);
    }
    /**
     * Creates an HTTP2 Based GatewayRoute.
     *
     * @param options - no http2 gateway route.
     * @stability stable
     */
    static http2(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpGatewayRouteSpecOptions(options);
        return new HttpGatewayRouteSpec(options, shared_interfaces_1.Protocol.HTTP2);
    }
    /**
     * Creates an gRPC Based GatewayRoute.
     *
     * @param options - no grpc gateway route.
     * @stability stable
     */
    static grpc(options) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcGatewayRouteSpecOptions(options);
        return new GrpcGatewayRouteSpec(options);
    }
}
exports.GatewayRouteSpec = GatewayRouteSpec;
_b = JSII_RTTI_SYMBOL_1;
GatewayRouteSpec[_b] = { fqn: "@aws-cdk/aws-appmesh.GatewayRouteSpec", version: "1.139.0" };
class HttpGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options, protocol) {
        super();
        this.routeTarget = options.routeTarget;
        this.routeType = protocol;
        this.match = options.match;
        this.priority = options.priority;
    }
    bind(scope) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        const pathMatchConfig = ((_d = (_c = this.match) === null || _c === void 0 ? void 0 : _c.path) !== null && _d !== void 0 ? _d : http_route_path_match_1.HttpGatewayRoutePathMatch.startsWith('/')).bind(scope);
        const rewriteRequestHostname = (_e = this.match) === null || _e === void 0 ? void 0 : _e.rewriteRequestHostname;
        const prefixPathRewrite = pathMatchConfig.prefixPathRewrite;
        const wholePathRewrite = pathMatchConfig.wholePathRewrite;
        const httpConfig = {
            match: {
                prefix: pathMatchConfig.prefixPathMatch,
                path: pathMatchConfig.wholePathMatch,
                hostname: (_g = (_f = this.match) === null || _f === void 0 ? void 0 : _f.hostname) === null || _g === void 0 ? void 0 : _g.bind(scope).hostnameMatch,
                method: (_h = this.match) === null || _h === void 0 ? void 0 : _h.method,
                headers: (_k = (_j = this.match) === null || _j === void 0 ? void 0 : _j.headers) === null || _k === void 0 ? void 0 : _k.map(header => header.bind(scope).headerMatch),
                queryParameters: (_m = (_l = this.match) === null || _l === void 0 ? void 0 : _l.queryParameters) === null || _m === void 0 ? void 0 : _m.map(queryParameter => queryParameter.bind(scope).queryParameterMatch),
            },
            action: {
                target: {
                    virtualService: {
                        virtualServiceName: this.routeTarget.virtualServiceName,
                    },
                },
                rewrite: rewriteRequestHostname !== undefined || prefixPathRewrite || wholePathRewrite
                    ? {
                        hostname: rewriteRequestHostname === undefined
                            ? undefined
                            : {
                                defaultTargetHostname: rewriteRequestHostname ? 'ENABLED' : 'DISABLED',
                            },
                        prefix: prefixPathRewrite,
                        path: wholePathRewrite,
                    }
                    : undefined,
            },
        };
        return {
            priority: this.priority,
            httpSpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP ? httpConfig : undefined,
            http2SpecConfig: this.routeType === shared_interfaces_1.Protocol.HTTP2 ? httpConfig : undefined,
        };
    }
}
class GrpcGatewayRouteSpec extends GatewayRouteSpec {
    constructor(options) {
        super();
        this.match = options.match;
        this.routeTarget = options.routeTarget;
        this.priority = options.priority;
    }
    bind(scope) {
        var _c;
        const metadataMatch = this.match.metadata;
        utils_1.validateGrpcGatewayRouteMatch(this.match);
        utils_1.validateGrpcMatchArrayLength(metadataMatch);
        return {
            grpcSpecConfig: {
                match: {
                    serviceName: this.match.serviceName,
                    hostname: (_c = this.match.hostname) === null || _c === void 0 ? void 0 : _c.bind(scope).hostnameMatch,
                    metadata: metadataMatch === null || metadataMatch === void 0 ? void 0 : metadataMatch.map(metadata => metadata.bind(scope).headerMatch),
                },
                action: {
                    target: {
                        virtualService: {
                            virtualServiceName: this.routeTarget.virtualServiceName,
                        },
                    },
                    rewrite: this.match.rewriteRequestHostname === undefined
                        ? undefined
                        : {
                            hostname: {
                                defaultTargetHostname: this.match.rewriteRequestHostname ? 'ENABLED' : 'DISABLED',
                            },
                        },
                },
            },
            priority: this.priority,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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