import { ILayoutRestorer, JupyterFrontEnd } from '@jupyterlab/application';
import { ReadonlyJSONObject } from '@lumino/coreutils';
import { CommandRegistry } from '@lumino/commands';
import { Message } from '@lumino/messaging';
import { VirtualElement } from '@lumino/virtualdom';
import { CommandPalette, Widget } from '@lumino/widgets';
import { IMosaikDockerExtension } from '../tokens';
export declare namespace CommandItem {
    /** Define the initialization options for class CommandItem. */
    interface IOptions extends CommandPalette.IItemOptions {
        /** JupyterLab command registry. */
        commands: CommandRegistry;
    }
}
/**
 * A concrete implementation of `CommandPalette.IItem`.
 * Intended for use with class SimCommandTab.
 */
export declare class CommandItem implements CommandPalette.IItem {
    /**
     * Construct a new command item.
     * @param options - command item initialization options
     * @returns command item instance
     */
    constructor(options: CommandItem.IOptions);
    /**
     * The category for the command item.
     */
    readonly category: string;
    /**
     * The command to execute when the item is triggered.
     */
    readonly command: string;
    /**
     * The arguments for the command.
     */
    readonly args: ReadonlyJSONObject;
    /**
     * The rank for the command item.
     */
    readonly rank: number;
    /**
     * The display label for the command item.
     */
    get label(): string;
    /**
     * The icon renderer for the command item.
     */
    get icon(): VirtualElement.IRenderer | undefined | string;
    /**
     * The icon class for the command item.
     */
    get iconClass(): string;
    /**
     * The icon label for the command item.
     */
    get iconLabel(): string;
    /**
     * The display caption for the command item.
     */
    get caption(): string;
    /**
     * The extra class name for the command item.
     */
    get className(): string;
    /**
     * The dataset for the command item.
     */
    get dataset(): CommandRegistry.Dataset;
    /**
     * Whether the command item is enabled.
     */
    get isEnabled(): boolean;
    /**
     * Whether the command item is toggled.
     */
    get isToggled(): boolean;
    /**
     * Whether the command item is visible.
     */
    get isVisible(): boolean;
    /**
     * The key binding for the command item.
     */
    get keyBinding(): CommandRegistry.IKeyBinding | null;
    /**
     * Normalize a category for a command item.
     */
    private _normalizeCategory;
    /** Reference to JupyterLab command registry. */
    private _commands;
}
export declare namespace SimCommandTab {
    /** Define the initialization options for class SimCommandTab. */
    interface IOptions {
        /** The command registry for use with the command side bar tab. */
        commands: CommandRegistry;
        /** The category for use with the command side bar tab. */
        category: string;
        /** A custom renderer for use with the command side bar tab. */
        renderer: CommandPalette.IRenderer;
        /** mosaik-docker extension model. */
        model: IMosaikDockerExtension;
    }
}
/**
 * This widget displays the mosaik-docker commands in a side bar tab.
 */
export declare class SimCommandTab extends Widget {
    /**
     * Construct a new command side bar tab.
     * @param options - The options for initializing the side bar tab.
     * @returns widget instance
     */
    constructor(options: SimCommandTab.IOptions);
    /**
     * Dispose of the resources held by the widget.
     */
    dispose(): void;
    /**
     * The command registry used by the command side bar tab.
     */
    readonly commands: CommandRegistry;
    /**
     * The renderer used by the command side bar tab.
     */
    readonly renderer: CommandPalette.IRenderer;
    /**
     * The command side bar tab category node, which displays the category title.
     */
    get categoryNode(): HTMLDivElement;
    /**
     * The command side bar tab content node, which holds the command item nodes.
     */
    get contentNode(): HTMLUListElement;
    /**
     * A read-only array of the command items in the side bar tab.
     */
    get items(): ReadonlyArray<CommandPalette.IItem>;
    /**
     * Add a command item to the command side bar tab.
     * @param options - options for creating the command item
     * @returns The command item added to the side bar tab
     */
    addItem(command: string): CommandPalette.IItem;
    /**
     * Handle the DOM events for the command side bar tab.
     * @param event - The DOM event sent to the command side bar tab.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the command side bar tab's DOM node.
     * It should not be called directly by user code.
     */
    handleEvent(event: Event): void;
    /**
     * A message handler invoked on a `'before-attach'` message.
     */
    protected onBeforeAttach(msg: Message): void;
    /**
     * A message handler invoked on an `'after-detach'` message.
     */
    protected onAfterDetach(msg: Message): void;
    /**
     * A message handler invoked on an `'update-request'` message.
     */
    protected onUpdateRequest(msg: Message): void;
    /**
     * Handle the `'click'` event for the command side bar tab.
     * @param event - mouse event
     */
    private _evtClick;
    /**
     * Execute the command item at the given index, if possible.
     * @param index - position index of command in the side tab
     */
    private _execute;
    /**
     * Create the DOM node for a command side bar tab.
     * @private
     * @returns HTML div element
     */
    private static _createNode;
    /** The (only) command tab category. */
    private _category;
    /** Array of command palette items. */
    private _items;
}
/**
 * Add new side tab for displaying mosaik-docker commands
 * @param app - JupyterLab frontend
 * @param model - mosaik-docker extension model
 * @param restorer - JupyterLab layout restorer
 */
export declare function addSimTab(app: JupyterFrontEnd, model: IMosaikDockerExtension, restorer: ILayoutRestorer | null): void;
