import * as React from 'react';
import { ReactWidget } from '@jupyterlab/apputils';
import { Widget } from '@lumino/widgets';
import { IMosaikDockerExtension, MosaikDocker } from '../tokens';
/**
 * This namespace provides the definition of the initialization options
 * for the SimStatusWidget class and the SimStatusComponent class.
 */
export declare namespace SimStatusWidget {
    /** Initialization options for the SimStatusWidget widget. */
    interface IOptions extends Widget.IOptions {
        /** mosaik-docker extension model. */
        model: IMosaikDockerExtension;
    }
    /** Initialization options for SimStatusComponent class. */
    interface IComponentProperties {
        /** mosaik-docker extension model. */
        model: IMosaikDockerExtension;
    }
}
/**
 * This class implements a main area widget (React widget)
 * for displaying the status of all simulation of the
 * active simulation setup.
 */
export declare class SimStatusWidget extends ReactWidget {
    /**
     * Create an instance of the widget.
     * @param options - widget initialization options
     * @returns widget instance
     */
    constructor(options: SimStatusWidget.IOptions);
    /**
     * Render the React element.
     * @returns React element
     */
    render(): React.ReactElement;
    /**
     * Update the status information to be displayed by the widget.
     * @param status - status of all simulations of the currently active simulation setup
     */
    updateStatus(status: MosaikDocker.ISimStatus): Promise<void>;
    /** mosaik-docker extension model. */
    private _model;
}
/**
 * This class implements the React component for class SimStatusWidget.
 */
export declare class SimStatusComponent extends React.Component<SimStatusWidget.IComponentProperties> {
    /**
     * Create an instance of the widget's React component.
     * @param props - React component properties
     * @returns React component instance
     */
    constructor(props: SimStatusWidget.IComponentProperties);
    /** Render the "template" for the status information widget as React component.
     * This template comprises a button for refreshing the widget and an empty
     * element (div) intended for displaying the simulation status (to be updated
     * by calling SimStatusWidget's updateStatus method).
     * @returns React element
     */
    render(): React.ReactElement;
}
