import { Widget } from '@lumino/widgets';
/**
 * This widget displays a dialog that lets users enter the name
 * of a new simulation setup. This dialog is used by the command
 * for creating new simulation setups.
 */
export declare class SimSetupCreateForm extends Widget {
    /**
     * Returns an instance of the SimSetupCreateForm class.
     * @returns widget instance
     */
    constructor();
    /**
     * Create the HTML element for the widget.
     * @private
     * @returns HTML element
     */
    private static _createFormNode;
    /**
     * Returns the input value (using the placeholder value as default).
     */
    getValue(): string;
    /** Default value for simulation setup name (also used as placeholder in the widget). */
    private static _defaultSetupName;
}
