import { JupyterFrontEnd } from '@jupyterlab/application';
import { ToolbarButton } from '@jupyterlab/apputils';
import { FileBrowser } from '@jupyterlab/filebrowser';
import { IMosaikDockerExtension } from '../tokens';
/**
 * This function adds an additional button to the fileBrowser
 * browser toolbar for creating a new simulation setup.
 * @param app - JupyterLab frontend
 * @param model - mosaik-docker extension model
 * @param fileBrowser - JupyterLab file browser
 */
export declare function addSimSetupCreateButton(app: JupyterFrontEnd, model: IMosaikDockerExtension, fileBrowser: FileBrowser): void;
export declare namespace SimSetupCreateButton {
    /** Initialization options for SimSetupCreateButton class. */
    interface IOptions {
        /** JupyterLab frontend. */
        app: JupyterFrontEnd;
        /** mosaik-docker extension model. */
        model: IMosaikDockerExtension;
    }
}
/**
 * This class implements a button for creating a new simulation
 * setup. This button is intended to be added to the file browser
 * toolbar.
 */
export declare class SimSetupCreateButton extends ToolbarButton {
    /**
     * Returns an instance of the SimSetupCreateButton class.
     * @param options - initialization options
     * @returns toolbar button instance
     */
    constructor(options: SimSetupCreateButton.IOptions);
}
