import * as React from 'react';
import { ReactWidget } from '@jupyterlab/apputils';
import { Widget } from '@lumino/widgets';
import { IMosaikDockerExtension, MosaikDocker } from '../tokens';
export declare namespace SimSetupConfigureWidget {
    /** Initialization options for SimSetupConfigureWidget class. */
    interface IOptions extends Widget.IOptions {
        /** mosaik-docker extension model. */
        model: IMosaikDockerExtension;
        /** Simulation setup configuration data. */
        configData: MosaikDocker.IConfigData;
    }
    /** Initialization options for SimSetupConfigureComponent class. */
    interface IComponentProperties {
        /** mosaik-docker extension model. */
        model: IMosaikDockerExtension;
        /** Instance of simulation setup configuration widget. */
        widget: SimSetupConfigureWidget;
        /** Simulation setup configuration data. */
        configData: MosaikDocker.IConfigData;
    }
}
/**
 * This class implements a main area widget (React widget)
 * for configuring a simulation setup.
 */
export declare class SimSetupConfigureWidget extends ReactWidget {
    /**
     * Create an instance of the widget.
     * @param options - widget initialization options
     * @returns widget instance
     */
    constructor(options: SimSetupConfigureWidget.IOptions);
    /**
     * Render the widget.
     * @returns React widget
     */
    render(): React.ReactElement;
    /**
     * Retrieve the configuration data specified by the user.
     * @returns simulation setup configuration
     */
    getConfigData(): MosaikDocker.IOrchestratorConfigData;
    /** mosaik-docker extension model. */
    private _model;
    /** Initial simulation setup configuration data. */
    private _configData;
}
/**
 * This class implements the React component for class SimSetupConfigureWidget.
 */
export declare class SimSetupConfigureComponent extends React.Component<SimSetupConfigureWidget.IComponentProperties> {
    /**
     * Create an instance of the widget's React component.
     * @param props - React component properties
     * @returns React component instance
     */
    constructor(props: SimSetupConfigureWidget.IComponentProperties);
    /**
     * Render the React element.
     * @returns React element
     */
    render(): React.ReactElement;
    /** Path to the simulation setup root directory. */
    private _simSetupDir;
}
