import { MainAreaWidget } from '@jupyterlab/apputils';
import { JSONObject } from '@lumino/coreutils';
export declare namespace SimSetupBuildWidget {
    /** Initialization options for SimSetupBuildWidget class. */
    interface IOptions {
        /** Path to simulation setup root directory. */
        simSetupDir: string;
    }
}
/**
 * This class is a main area widget that displays the build process of a simulation setup.
 */
export declare class SimSetupBuildWidget extends MainAreaWidget {
    /**
     * Returns an instance of the SimSetupBuildWidget class.
     * @param options - widget initialization options
     * @returns widget instance
     */
    constructor(options: SimSetupBuildWidget.IOptions);
    /**
     * Call this method to update and display information about the build process.
     * @param statusUpdate - JSON object
     */
    updateStatus(statusUpdate: JSONObject): Promise<void>;
    /**
     * Call this method to once the build process has ended.
     * This will display the final status update and remove the spinner.
     * @param statusUpdate - JSON object
     */
    done(statusDone?: JSONObject): Promise<void>;
    /** HTML element containing the spinner. */
    private _statusContentSpinner;
    /** HTML element displaying the build status. */
    private _statusContent;
}
