import { Widget } from '@lumino/widgets';
/**
 * This namespace provides the definition of initialization options
 * and the return type for the SimSelectForm class.
 */
export declare namespace SimSelectForm {
    /** Initialization options for the SimSelectForm widget. */
    interface IOptions {
        /** Display text for selecting one item. */
        textSelectItem: string;
        /** Display text for selecting all items. */
        textSelectAll: string;
        /** List of choices. */
        items: Array<string>;
    }
    /** Return type of the SimSelectForm widget. */
    interface IReturnValue {
        /** Flag for selecting all items. */
        selectAll: boolean;
        /** In case not all items have been selected, specify which one was selected. */
        selectItem?: string;
    }
}
/**
 * This widget displays a dialog that lets users select from a list of items either
 * all items or just one specific item.
 */
export declare class SimSelectForm extends Widget {
    /**
     * Returns an instance of the SimSelectForm class.
     * @param options - widget initialization options
     * @returns widget instance
     */
    constructor(options: SimSelectForm.IOptions);
    /**
     * Create the HTML element for the widget.
     * @private
     * @param options - widget initialization options
     * @returns HTML element
     */
    private static _createFormNode;
    /**
     * Returns the user selection.
     */
    getValue(): SimSelectForm.IReturnValue;
}
