import { KernelMessage } from '@jupyterlab/services';
/**
 * This namespace contains the interface definitions and methods required
 * for the low-level interaction with the functionality provided by
 * package mosaik_docker_jl on the server.
 */
export declare namespace MosaikDockerAPI {
    /**
     * Return type for low-level server API calls.
     */
    interface IRequestResponse {
        code: number;
        message?: any;
        error?: string;
    }
    /**
     * Return type for low-level results from executing code on the server.
     */
    interface IExecuteResponse {
        status: string;
        error?: string;
    }
    /**
     * Send an HTTP request to the server (mosaik_docker_jl backend).
     * The request will be parsed there and the appropriate API will be called (blocking).
     * The results from this API call are then returned (asynchronously).
     * @param endPoint - request endpoints (as defined by the mosaik_docker_jl backend)
     *
     * @param method - HTTP method
     * @param request - payload of HTTP request
     * @returns Low-level API response
     */
    function sendRequest(endPoint: string, method?: string, request?: Record<string, any>): Promise<IRequestResponse>;
    /**
     * Execute Python code on the server (via a dedicated Python kernel).
     * In the Python code, an instance of class CallbackComm (imported from
     * mosaik_docker_jl.comm) named 'comm' is available, which can be used
     * to send back data and trigger the execution of the callback functions
     * 'onMsg' and 'onClose'.
     *
     * @param commTargetPrefix - prefix used for the kernel comm target
     * @param executeCode - Python code to be executed
     * @param onMsg - data from the kernel can be sent back to the frontend asynchronously via this callback function
     * @param onClose - this callback function is executed when the kernel closes
     * @returns execution status
     */
    function executeWithCallbacks(commTargetPrefix: string, executeCode: string, onMsg: (msg: KernelMessage.ICommMsgMsg) => void | PromiseLike<void>, onClose: (msg: KernelMessage.ICommCloseMsg) => void | PromiseLike<void>): Promise<IExecuteResponse>;
}
