/**
 * The IDs of the mosaik-docker-jl commands that are exposed to the user (main menu, sim tab, etc.).
 */
export var CommandIDs;
(function (CommandIDs) {
    /** Command ID for creating new simulation setups. */
    CommandIDs.createSimSetup = 'mosaik-docker-jl:create-sim-setup';
    /** Command ID for configuring simulation setups. */
    CommandIDs.configureSimSetup = 'mosaik-docker-jl:configure-sim-setup';
    /** Command ID for checking simulation setups. */
    CommandIDs.checkSimSetup = 'mosaik-docker-jl:check-sim-setup';
    /** Command ID for building simulation setups. */
    CommandIDs.buildSimSetup = 'mosaik-docker-jl:build-sim-setup';
    /** Command ID for starting a new simulation. */
    CommandIDs.startSim = 'mosaik-docker-jl:start-sim';
    /** Command ID for canceling a simulation. */
    CommandIDs.cancelSim = 'mosaik-docker-jl:cancel-sim';
    /** Command ID for clearing a new simulation. */
    CommandIDs.clearSim = 'mosaik-docker-jl:clear-sim';
    /** Command ID for retrieving the status of all simulations of a simulation setup. */
    CommandIDs.getSimStatus = 'mosaik-docker-jl:get-sim-status';
    /** Command ID for retrieving the results of simulations. */
    CommandIDs.getSimResults = 'mosaik-docker-jl:get-sim-results';
    /** Command ID for deleting simulation setups. */
    CommandIDs.deleteSimSetup = 'mosaik-docker-jl:delete-sim-setup';
    /** For convenience, put all command IDs in a single list. */
    CommandIDs.all = [
        CommandIDs.createSimSetup,
        CommandIDs.configureSimSetup,
        CommandIDs.checkSimSetup,
        CommandIDs.buildSimSetup,
        CommandIDs.startSim,
        CommandIDs.cancelSim,
        CommandIDs.clearSim,
        CommandIDs.getSimStatus,
        CommandIDs.getSimResults,
        CommandIDs.deleteSimSetup
    ];
    /** Additional command ID for opening the mosaik-docker documentation. */
    CommandIDs.openMosaikDockerDocs = 'mosaik-docker-jl:open-mosaik-docker-docs';
    /** Additional command ID for opening the JupyterLab mosaik-docker extension documentation. */
    CommandIDs.openMosaikDockerJLDocs = 'mosaik-docker-jl:open-mosaik-docker-jl-docs';
    /** Additional command ID for opening the mosaik-docker CLI documentation. */
    CommandIDs.openMosaikDockerCliDocs = 'mosaik-docker-jl:open-mosaik-docker-cli-docs';
    /** Additional command ID for opening the mosaik-docker Python documentation. */
    CommandIDs.openMosaikDockerPyDocs = 'mosaik-docker-jl:open-mosaik-docker-py-docs';
    /** For convenience, put all additional command IDs for opening documentation in a single list. */
    CommandIDs.docs = [
        CommandIDs.openMosaikDockerDocs,
        CommandIDs.openMosaikDockerJLDocs,
        CommandIDs.openMosaikDockerCliDocs,
        CommandIDs.openMosaikDockerPyDocs
    ];
})(CommandIDs || (CommandIDs = {}));
