# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerArgs', 'Trigger']

@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 query_id: pulumi.Input[str],
                 threshold: pulumi.Input['TriggerThresholdArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]]] = None):
        """
        The set of arguments for constructing a Trigger resource.
        :param pulumi.Input[str] dataset: The dataset this trigger is associated with.
        :param pulumi.Input[str] query_id: The ID of the Query that the Trigger will execute.
        :param pulumi.Input['TriggerThresholdArgs'] threshold: A configuration block (described below) describing the threshold of the trigger.
        :param pulumi.Input[str] description: Description of the trigger.
        :param pulumi.Input[bool] disabled: The state of the trigger. If true, the trigger will not be run. Defaults to false.
        :param pulumi.Input[int] frequency: The interval (in seconds) in which to check the results of the query’s calculation against the threshold. Value must be divisible by 60 and between 60 and 86400 (between 1 minute and 1 day). Defaults to 900 (15 minutes).
        :param pulumi.Input[str] name: Name of the trigger.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the trigger fires.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "query_id", query_id)
        pulumi.set(__self__, "threshold", threshold)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this trigger is associated with.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Input[str]:
        """
        The ID of the Query that the Trigger will execute.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_id", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input['TriggerThresholdArgs']:
        """
        A configuration block (described below) describing the threshold of the trigger.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input['TriggerThresholdArgs']):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The state of the trigger. If true, the trigger will not be run. Defaults to false.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[int]]:
        """
        The interval (in seconds) in which to check the results of the query’s calculation against the threshold. Value must be divisible by 60 and between 60 and 86400 (between 1 minute and 1 day). Defaults to 900 (15 minutes).
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]]]:
        """
        Zero or more configuration blocks (described below) with the recipients to notify when the trigger fires.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]]]):
        pulumi.set(self, "recipients", value)


@pulumi.input_type
class _TriggerState:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]]] = None,
                 threshold: Optional[pulumi.Input['TriggerThresholdArgs']] = None):
        """
        Input properties used for looking up and filtering Trigger resources.
        :param pulumi.Input[str] dataset: The dataset this trigger is associated with.
        :param pulumi.Input[str] description: Description of the trigger.
        :param pulumi.Input[bool] disabled: The state of the trigger. If true, the trigger will not be run. Defaults to false.
        :param pulumi.Input[int] frequency: The interval (in seconds) in which to check the results of the query’s calculation against the threshold. Value must be divisible by 60 and between 60 and 86400 (between 1 minute and 1 day). Defaults to 900 (15 minutes).
        :param pulumi.Input[str] name: Name of the trigger.
        :param pulumi.Input[str] query_id: The ID of the Query that the Trigger will execute.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the trigger fires.
        :param pulumi.Input['TriggerThresholdArgs'] threshold: A configuration block (described below) describing the threshold of the trigger.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this trigger is associated with.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the trigger.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The state of the trigger. If true, the trigger will not be run. Defaults to false.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[int]]:
        """
        The interval (in seconds) in which to check the results of the query’s calculation against the threshold. Value must be divisible by 60 and between 60 and 86400 (between 1 minute and 1 day). Defaults to 900 (15 minutes).
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the trigger.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Query that the Trigger will execute.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_id", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]]]:
        """
        Zero or more configuration blocks (described below) with the recipients to notify when the trigger fires.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerRecipientArgs']]]]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input['TriggerThresholdArgs']]:
        """
        A configuration block (described below) describing the threshold of the trigger.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input['TriggerThresholdArgs']]):
        pulumi.set(self, "threshold", value)


class Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerRecipientArgs']]]]] = None,
                 threshold: Optional[pulumi.Input[pulumi.InputType['TriggerThresholdArgs']]] = None,
                 __props__=None):
        """
        ## # Resource: Trigger

        Creates a trigger. For more information about triggers, check out [Alert with Triggers](https://docs.honeycomb.io/working-with-your-data/triggers/).

        ## Import

        Triggers can be imported using a combination of the dataset name and their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/trigger:Trigger my_trigger my-dataset/AeZzSoWws9G
        ```

         You can find the ID in the URL bar when visiting the trigger from the UI.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this trigger is associated with.
        :param pulumi.Input[str] description: Description of the trigger.
        :param pulumi.Input[bool] disabled: The state of the trigger. If true, the trigger will not be run. Defaults to false.
        :param pulumi.Input[int] frequency: The interval (in seconds) in which to check the results of the query’s calculation against the threshold. Value must be divisible by 60 and between 60 and 86400 (between 1 minute and 1 day). Defaults to 900 (15 minutes).
        :param pulumi.Input[str] name: Name of the trigger.
        :param pulumi.Input[str] query_id: The ID of the Query that the Trigger will execute.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerRecipientArgs']]]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the trigger fires.
        :param pulumi.Input[pulumi.InputType['TriggerThresholdArgs']] threshold: A configuration block (described below) describing the threshold of the trigger.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: Trigger

        Creates a trigger. For more information about triggers, check out [Alert with Triggers](https://docs.honeycomb.io/working-with-your-data/triggers/).

        ## Import

        Triggers can be imported using a combination of the dataset name and their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/trigger:Trigger my_trigger my-dataset/AeZzSoWws9G
        ```

         You can find the ID in the URL bar when visiting the trigger from the UI.

        :param str resource_name: The name of the resource.
        :param TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_id: Optional[pulumi.Input[str]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerRecipientArgs']]]]] = None,
                 threshold: Optional[pulumi.Input[pulumi.InputType['TriggerThresholdArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerArgs.__new__(TriggerArgs)

            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["description"] = description
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["name"] = name
            if query_id is None and not opts.urn:
                raise TypeError("Missing required property 'query_id'")
            __props__.__dict__["query_id"] = query_id
            __props__.__dict__["recipients"] = recipients
            if threshold is None and not opts.urn:
                raise TypeError("Missing required property 'threshold'")
            __props__.__dict__["threshold"] = threshold
        super(Trigger, __self__).__init__(
            'honeycomb:index/trigger:Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            frequency: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            query_id: Optional[pulumi.Input[str]] = None,
            recipients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerRecipientArgs']]]]] = None,
            threshold: Optional[pulumi.Input[pulumi.InputType['TriggerThresholdArgs']]] = None) -> 'Trigger':
        """
        Get an existing Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this trigger is associated with.
        :param pulumi.Input[str] description: Description of the trigger.
        :param pulumi.Input[bool] disabled: The state of the trigger. If true, the trigger will not be run. Defaults to false.
        :param pulumi.Input[int] frequency: The interval (in seconds) in which to check the results of the query’s calculation against the threshold. Value must be divisible by 60 and between 60 and 86400 (between 1 minute and 1 day). Defaults to 900 (15 minutes).
        :param pulumi.Input[str] name: Name of the trigger.
        :param pulumi.Input[str] query_id: The ID of the Query that the Trigger will execute.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TriggerRecipientArgs']]]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the trigger fires.
        :param pulumi.Input[pulumi.InputType['TriggerThresholdArgs']] threshold: A configuration block (described below) describing the threshold of the trigger.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerState.__new__(_TriggerState)

        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["description"] = description
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["name"] = name
        __props__.__dict__["query_id"] = query_id
        __props__.__dict__["recipients"] = recipients
        __props__.__dict__["threshold"] = threshold
        return Trigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The dataset this trigger is associated with.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the trigger.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The state of the trigger. If true, the trigger will not be run. Defaults to false.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[int]:
        """
        The interval (in seconds) in which to check the results of the query’s calculation against the threshold. Value must be divisible by 60 and between 60 and 86400 (between 1 minute and 1 day). Defaults to 900 (15 minutes).
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Output[str]:
        """
        The ID of the Query that the Trigger will execute.
        """
        return pulumi.get(self, "query_id")

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Output[Optional[Sequence['outputs.TriggerRecipient']]]:
        """
        Zero or more configuration blocks (described below) with the recipients to notify when the trigger fires.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output['outputs.TriggerThreshold']:
        """
        A configuration block (described below) describing the threshold of the trigger.
        """
        return pulumi.get(self, "threshold")

