# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BoardQuery',
    'GetQuerySpecificationCalculationResult',
    'GetQuerySpecificationFilterResult',
    'GetQuerySpecificationOrderResult',
    'TriggerRecipient',
    'TriggerThreshold',
]

@pulumi.output_type
class BoardQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryId":
            suggest = "query_id"
        elif key == "queryAnnotationId":
            suggest = "query_annotation_id"
        elif key == "queryStyle":
            suggest = "query_style"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BoardQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BoardQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BoardQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 query_id: str,
                 caption: Optional[str] = None,
                 query_annotation_id: Optional[str] = None,
                 query_style: Optional[str] = None):
        """
        :param str dataset: The dataset this query is associated with.
        :param str query_id: The ID of the Query to run.
        :param str caption: A description of the query that will be displayed on the board. Supports markdown.
        :param str query_annotation_id: The ID of the Query Annotation to associate with this query.
        :param str query_style: How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "query_id", query_id)
        if caption is not None:
            pulumi.set(__self__, "caption", caption)
        if query_annotation_id is not None:
            pulumi.set(__self__, "query_annotation_id", query_annotation_id)
        if query_style is not None:
            pulumi.set(__self__, "query_style", query_style)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The dataset this query is associated with.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> str:
        """
        The ID of the Query to run.
        """
        return pulumi.get(self, "query_id")

    @property
    @pulumi.getter
    def caption(self) -> Optional[str]:
        """
        A description of the query that will be displayed on the board. Supports markdown.
        """
        return pulumi.get(self, "caption")

    @property
    @pulumi.getter(name="queryAnnotationId")
    def query_annotation_id(self) -> Optional[str]:
        """
        The ID of the Query Annotation to associate with this query.
        """
        return pulumi.get(self, "query_annotation_id")

    @property
    @pulumi.getter(name="queryStyle")
    def query_style(self) -> Optional[str]:
        """
        How the query should be displayed within the board, either `graph` (the default), `table` or `combo`.
        """
        return pulumi.get(self, "query_style")


@pulumi.output_type
class GetQuerySpecificationCalculationResult(dict):
    def __init__(__self__, *,
                 op: str,
                 column: Optional[str] = None):
        """
        :param str op: The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str column: The column to apply the operator to, not needed with `COUNT`.
        """
        pulumi.set(__self__, "op", op)
        if column is not None:
            pulumi.set(__self__, "column", column)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        The column to apply the operator to, not needed with `COUNT`.
        """
        return pulumi.get(self, "column")


@pulumi.output_type
class GetQuerySpecificationFilterResult(dict):
    def __init__(__self__, *,
                 column: str,
                 op: str,
                 value: Optional[str] = None,
                 value_boolean: Optional[bool] = None,
                 value_float: Optional[float] = None,
                 value_integer: Optional[int] = None,
                 value_string: Optional[str] = None):
        """
        :param str column: The column to apply the filter to.
        :param str op: The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        :param str value: Deprecated: use the explicitly typed `value_string` instead. This variant will break queries when used with non-string columns. Mutually exclusive with the other `value_*` options.
        :param bool value_boolean: The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        :param float value_float: The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        :param int value_integer: The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        :param str value_string: The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        pulumi.set(__self__, "column", column)
        pulumi.set(__self__, "op", op)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_boolean is not None:
            pulumi.set(__self__, "value_boolean", value_boolean)
        if value_float is not None:
            pulumi.set(__self__, "value_float", value_float)
        if value_integer is not None:
            pulumi.set(__self__, "value_integer", value_integer)
        if value_string is not None:
            pulumi.set(__self__, "value_string", value_string)

    @property
    @pulumi.getter
    def column(self) -> str:
        """
        The column to apply the filter to.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, see the supported list of filter operators at [Filter Operators](https://docs.honeycomb.io/api/query-specification/#filter-operators). Not all operators require a value.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Deprecated: use the explicitly typed `value_string` instead. This variant will break queries when used with non-string columns. Mutually exclusive with the other `value_*` options.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueBoolean")
    def value_boolean(self) -> Optional[bool]:
        """
        The value used for the filter when the column is a boolean. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_boolean")

    @property
    @pulumi.getter(name="valueFloat")
    def value_float(self) -> Optional[float]:
        """
        The value used for the filter when the column is a float. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_float")

    @property
    @pulumi.getter(name="valueInteger")
    def value_integer(self) -> Optional[int]:
        """
        The value used for the filter when the column is an integer. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_integer")

    @property
    @pulumi.getter(name="valueString")
    def value_string(self) -> Optional[str]:
        """
        The value used for the filter when the column is a string. Mutually exclusive with `value` and the other `value_*` options.
        """
        return pulumi.get(self, "value_string")


@pulumi.output_type
class GetQuerySpecificationOrderResult(dict):
    def __init__(__self__, *,
                 column: Optional[str] = None,
                 op: Optional[str] = None,
                 order: Optional[str] = None):
        """
        :param str column: Either a column present in `breakdown` or a column to `op` applies to.
        :param str op: The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        :param str order: The sort direction, if set must be `ascending` or `descending`.
        """
        if column is not None:
            pulumi.set(__self__, "column", column)
        if op is not None:
            pulumi.set(__self__, "op", op)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Either a column present in `breakdown` or a column to `op` applies to.
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def op(self) -> Optional[str]:
        """
        The calculation operator to apply, see the supported list of calculation operators at [Calculation Operators](https://docs.honeycomb.io/api/query-specification/#calculation-operators).
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        """
        The sort direction, if set must be `ascending` or `descending`.
        """
        return pulumi.get(self, "order")


@pulumi.output_type
class TriggerRecipient(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 target: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str id: The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        :param str target: Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        :param str type: The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of an already existing recipient. Should not be used in combination with `type` and `target`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        Target of the trigger recipient, this has another meaning depending on the type of recipient (see the table below). Should not be used in combination with `id`.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the trigger recipient, allowed types are `email`, `marker`, `pagerduty`, `slack` and `webhook`. Should not be used in combination with `id`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TriggerThreshold(dict):
    def __init__(__self__, *,
                 op: str,
                 value: float):
        """
        :param str op: The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        :param float value: The value to be used with the operator.
        """
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> str:
        """
        The operator to apply, allowed threshold operators are `>`, `>=`, `<`, and `<=`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        The value to be used with the operator.
        """
        return pulumi.get(self, "value")


