# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetQuerySpecificationResult',
    'AwaitableGetQuerySpecificationResult',
    'get_query_specification',
    'get_query_specification_output',
]

@pulumi.output_type
class GetQuerySpecificationResult:
    """
    A collection of values returned by GetQuerySpecification.
    """
    def __init__(__self__, breakdowns=None, calculations=None, end_time=None, filter_combination=None, filters=None, granularity=None, id=None, json=None, limit=None, orders=None, start_time=None, time_range=None):
        if breakdowns and not isinstance(breakdowns, list):
            raise TypeError("Expected argument 'breakdowns' to be a list")
        pulumi.set(__self__, "breakdowns", breakdowns)
        if calculations and not isinstance(calculations, list):
            raise TypeError("Expected argument 'calculations' to be a list")
        pulumi.set(__self__, "calculations", calculations)
        if end_time and not isinstance(end_time, int):
            raise TypeError("Expected argument 'end_time' to be a int")
        pulumi.set(__self__, "end_time", end_time)
        if filter_combination and not isinstance(filter_combination, str):
            raise TypeError("Expected argument 'filter_combination' to be a str")
        pulumi.set(__self__, "filter_combination", filter_combination)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if granularity and not isinstance(granularity, int):
            raise TypeError("Expected argument 'granularity' to be a int")
        pulumi.set(__self__, "granularity", granularity)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if orders and not isinstance(orders, list):
            raise TypeError("Expected argument 'orders' to be a list")
        pulumi.set(__self__, "orders", orders)
        if start_time and not isinstance(start_time, int):
            raise TypeError("Expected argument 'start_time' to be a int")
        pulumi.set(__self__, "start_time", start_time)
        if time_range and not isinstance(time_range, int):
            raise TypeError("Expected argument 'time_range' to be a int")
        pulumi.set(__self__, "time_range", time_range)

    @property
    @pulumi.getter
    def breakdowns(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "breakdowns")

    @property
    @pulumi.getter
    def calculations(self) -> Optional[Sequence['outputs.GetQuerySpecificationCalculationResult']]:
        return pulumi.get(self, "calculations")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[int]:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="filterCombination")
    def filter_combination(self) -> Optional[str]:
        return pulumi.get(self, "filter_combination")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetQuerySpecificationFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def granularity(self) -> Optional[int]:
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        JSON representation of the query according to the [Query Specification](https://docs.honeycomb.io/api/query-specification/#fields-on-a-query-specification), can be used as input for other resources.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter
    def limit(self) -> Optional[int]:
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def orders(self) -> Optional[Sequence['outputs.GetQuerySpecificationOrderResult']]:
        return pulumi.get(self, "orders")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[int]:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[int]:
        return pulumi.get(self, "time_range")


class AwaitableGetQuerySpecificationResult(GetQuerySpecificationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQuerySpecificationResult(
            breakdowns=self.breakdowns,
            calculations=self.calculations,
            end_time=self.end_time,
            filter_combination=self.filter_combination,
            filters=self.filters,
            granularity=self.granularity,
            id=self.id,
            json=self.json,
            limit=self.limit,
            orders=self.orders,
            start_time=self.start_time,
            time_range=self.time_range)


def get_query_specification(breakdowns: Optional[Sequence[str]] = None,
                            calculations: Optional[Sequence[pulumi.InputType['GetQuerySpecificationCalculationArgs']]] = None,
                            end_time: Optional[int] = None,
                            filter_combination: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetQuerySpecificationFilterArgs']]] = None,
                            granularity: Optional[int] = None,
                            limit: Optional[int] = None,
                            orders: Optional[Sequence[pulumi.InputType['GetQuerySpecificationOrderArgs']]] = None,
                            start_time: Optional[int] = None,
                            time_range: Optional[int] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQuerySpecificationResult:
    """
    ## # Data Source: _get_query_specification

    Construct a query that can be used in triggers and boards. For more information about the query specification, check out [Query Specification](https://docs.honeycomb.io/api/query-specification/).

    The `json` attribute contains a serialized JSON representation which can be passed to the `query_json` field of `Trigger` and `Board`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_honeycomb as honeycomb

    example = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
            op="AVG",
            column="duration_ms",
        )],
        filters=[
            honeycomb.GetQuerySpecificationFilterArgs(
                column="trace.parent_id",
                op="does-not-exist",
            ),
            honeycomb.GetQuerySpecificationFilterArgs(
                column="app.tenant",
                op="=",
                value="ThatSpecialTenant",
            ),
        ],
        filter_combination="AND",
        breakdowns=["app.tenant"],
        time_range=28800)
    pulumi.export("jsonQuery", example.json)
    ```


    :param Sequence[str] breakdowns: A list of fields to group by.
    :param Sequence[pulumi.InputType['GetQuerySpecificationCalculationArgs']] calculations: Zero or more configuration blocks (described below) with the calculations that should be displayed. If no calculations are specified, `COUNT` will be used.
    :param int end_time: The absolute end time of the query in Unix Time (= seconds since epoch).
    :param str filter_combination: How to combine multiple filters, either `AND` (default) or `OR`.
    :param Sequence[pulumi.InputType['GetQuerySpecificationFilterArgs']] filters: Zero or more configuration blocks (described below) with the filters that should be applied.
    :param int granularity: The time resolution of the query’s graph, in seconds. Valid values must be in between the query’s time range /10 at maximum, and /1000 at minimum.
    :param int limit: The maximum number of query results, must be between 1 and 1000.
    :param Sequence[pulumi.InputType['GetQuerySpecificationOrderArgs']] orders: Zero or more configuration blocks (described below) describing how to order the query results. Each term must appear in either `calculation` or `breakdowns`.
    :param int start_time: The absolute start time of the query in Unix Time (= seconds since epoch).
    :param int time_range: The time range of the query in seconds, defaults to two hours.
    """
    __args__ = dict()
    __args__['breakdowns'] = breakdowns
    __args__['calculations'] = calculations
    __args__['endTime'] = end_time
    __args__['filterCombination'] = filter_combination
    __args__['filters'] = filters
    __args__['granularity'] = granularity
    __args__['limit'] = limit
    __args__['orders'] = orders
    __args__['startTime'] = start_time
    __args__['timeRange'] = time_range
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('honeycomb:index/getQuerySpecification:GetQuerySpecification', __args__, opts=opts, typ=GetQuerySpecificationResult).value

    return AwaitableGetQuerySpecificationResult(
        breakdowns=__ret__.breakdowns,
        calculations=__ret__.calculations,
        end_time=__ret__.end_time,
        filter_combination=__ret__.filter_combination,
        filters=__ret__.filters,
        granularity=__ret__.granularity,
        id=__ret__.id,
        json=__ret__.json,
        limit=__ret__.limit,
        orders=__ret__.orders,
        start_time=__ret__.start_time,
        time_range=__ret__.time_range)


@_utilities.lift_output_func(get_query_specification)
def get_query_specification_output(breakdowns: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   calculations: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetQuerySpecificationCalculationArgs']]]]] = None,
                                   end_time: Optional[pulumi.Input[Optional[int]]] = None,
                                   filter_combination: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetQuerySpecificationFilterArgs']]]]] = None,
                                   granularity: Optional[pulumi.Input[Optional[int]]] = None,
                                   limit: Optional[pulumi.Input[Optional[int]]] = None,
                                   orders: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetQuerySpecificationOrderArgs']]]]] = None,
                                   start_time: Optional[pulumi.Input[Optional[int]]] = None,
                                   time_range: Optional[pulumi.Input[Optional[int]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQuerySpecificationResult]:
    """
    ## # Data Source: _get_query_specification

    Construct a query that can be used in triggers and boards. For more information about the query specification, check out [Query Specification](https://docs.honeycomb.io/api/query-specification/).

    The `json` attribute contains a serialized JSON representation which can be passed to the `query_json` field of `Trigger` and `Board`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_honeycomb as honeycomb

    example = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
            op="AVG",
            column="duration_ms",
        )],
        filters=[
            honeycomb.GetQuerySpecificationFilterArgs(
                column="trace.parent_id",
                op="does-not-exist",
            ),
            honeycomb.GetQuerySpecificationFilterArgs(
                column="app.tenant",
                op="=",
                value="ThatSpecialTenant",
            ),
        ],
        filter_combination="AND",
        breakdowns=["app.tenant"],
        time_range=28800)
    pulumi.export("jsonQuery", example.json)
    ```


    :param Sequence[str] breakdowns: A list of fields to group by.
    :param Sequence[pulumi.InputType['GetQuerySpecificationCalculationArgs']] calculations: Zero or more configuration blocks (described below) with the calculations that should be displayed. If no calculations are specified, `COUNT` will be used.
    :param int end_time: The absolute end time of the query in Unix Time (= seconds since epoch).
    :param str filter_combination: How to combine multiple filters, either `AND` (default) or `OR`.
    :param Sequence[pulumi.InputType['GetQuerySpecificationFilterArgs']] filters: Zero or more configuration blocks (described below) with the filters that should be applied.
    :param int granularity: The time resolution of the query’s graph, in seconds. Valid values must be in between the query’s time range /10 at maximum, and /1000 at minimum.
    :param int limit: The maximum number of query results, must be between 1 and 1000.
    :param Sequence[pulumi.InputType['GetQuerySpecificationOrderArgs']] orders: Zero or more configuration blocks (described below) describing how to order the query results. Each term must appear in either `calculation` or `breakdowns`.
    :param int start_time: The absolute start time of the query in Unix Time (= seconds since epoch).
    :param int time_range: The time range of the query in seconds, defaults to two hours.
    """
    ...
