# coding: utf-8

"""
    Swifty OAuth API

    API for the Swifty OAuth Backend 

    The version of the OpenAPI document: 1.0.0
    Contact: paul.tindall@rxfoundry.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserInfoResponse(BaseModel):
    """
    UserInfoResponse
    """ # noqa: E501
    sub: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    given_name: Optional[StrictStr] = None
    family_name: Optional[StrictStr] = None
    preferred_username: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    permissions: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["sub", "email", "given_name", "family_name", "preferred_username", "name", "permissions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserInfoResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sub": obj.get("sub"),
            "email": obj.get("email"),
            "given_name": obj.get("given_name"),
            "family_name": obj.get("family_name"),
            "preferred_username": obj.get("preferred_username"),
            "name": obj.get("name"),
            "permissions": obj.get("permissions")
        })
        return _obj


