# rxfoundry.clients.swifty-oauth-api
API for the Swifty OAuth Backend


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import rxfoundry.clients.swifty_oauth_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import rxfoundry.clients.swifty_oauth_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import rxfoundry.clients.swifty_oauth_api
from rxfoundry.clients.swifty_oauth_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = rxfoundry.clients.swifty_oauth_api.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with rxfoundry.clients.swifty_oauth_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = rxfoundry.clients.swifty_oauth_api.OAuthApi(api_client)
    oauth_token_post_request = rxfoundry.clients.swifty_oauth_api.OauthTokenPostRequest() # OauthTokenPostRequest | 

    try:
        # Get a token
        api_response = api_instance.oauth_token_post(oauth_token_post_request)
        print("The response of OAuthApi->oauth_token_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling OAuthApi->oauth_token_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OAuthApi* | [**oauth_token_post**](docs/OAuthApi.md#oauth_token_post) | **POST** /oauth/token/ | Get a token
*OAuthApi* | [**oauth_userinfo_post**](docs/OAuthApi.md#oauth_userinfo_post) | **POST** /oauth/userinfo/ | Get user info


## Documentation For Models

 - [OauthTokenPostRequest](docs/OauthTokenPostRequest.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [UserInfoResponse](docs/UserInfoResponse.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author

paul.tindall@rxfoundry.com


