# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pandoc_styles',
 'pandoc_styles.config_dir.filter',
 'pandoc_styles.config_dir.postflight',
 'pandoc_styles.config_dir.preflight']

package_data = \
{'': ['*'],
 'pandoc_styles': ['config_dir/*', 'config_dir/css/*', 'config_dir/sass/*']}

install_requires = \
['libsass>=0.21,<0.22', 'panflute>=2.0,<3.0', 'ruamel.yaml>=0.16.0,<0.17.0']

entry_points = \
{'console_scripts': ['pandoc-styles = pandoc_styles.main:main',
                     'pandoc-styles-tools = pandoc_styles.cl_tools:main',
                     'pandoc_styles = pandoc_styles.main:main',
                     'pandoc_styles_tools = pandoc_styles.cl_tools:main']}

setup_kwargs = {
    'name': 'pandoc-styles',
    'version': '0.9.14',
    'description': 'A script to convert files with pandoc using styles.',
    'long_description': '# pandoc-styles\n\nThis script allows you to define styles for pandoc. In styles you can define, with which arguments pandoc should be invoked for different formats. In addition it allows to run scripts before and after a conversion and gives much power to these scripts and to filters.\n\n- [pandoc-styles](#pandoc-styles)\n  - [Installation](#installation)\n    - [Requirements](#requirements)\n    - [Install](#install)\n    - [Setup](#setup)\n  - [Usage](#usage)\n  - [Defining Styles](#defining-styles)\n    - [Basic Usage](#basic-usage)\n    - [Inheritance](#inheritance)\n  - [Stylepacks](#stylepacks)\n  - [Advanced Feature](#advanced-feature)\n    - [Adressing files in the configuration folder](#adressing-files-in-the-configuration-folder)\n    - [Verbatim Variables](#verbatim-variables)\n    - [Preflight](#preflight)\n    - [Process Sass](#process-sass)\n    - [Add to template](#add-to-template)\n    - [Replace in template](#replace-in-template)\n    - [Replace in output](#replace-in-output)\n    - [Postflight](#postflight)\n    - [Filter](#filter)\n    - [Advanced Example](#advanced-example)\n  - [Commandline tools](#commandline-tools)\n  - [Creating stylepacks](#creating-stylepacks)\n\n## Installation\n\n### Requirements\n\nTo use this script, you need the following:\n\n1. Python 3.6 or higher:\n    You can get [python here](https://www.python.org/).\n\n2. Pandoc 2.11 or higher:\n    You can download [pandoc here](http://pandoc.org/index.html).\n\n### Install\n\nNow you need to install this script itself. Open the console and enter:\n\n    pip3 install pandoc_styles\n    pandoc-styles --init\n\n### Setup\n\nDepending on your system, you may have to configure some settings for everything to work.\nUpon initialization this script created the directory "pandoc_styles" in your user folder. Inside you can find the config.yaml file. Set the option in there that are needed for your system.\n\n## Usage\n\nThe "pandoc_styles" folder can be used as a central point to store styles, scripts, filter etc. Some subfolders are pre-created for you to use.\n\nThe "styles.yaml" file contains all the styles. Here you define your styles and the script looks here for styles specified in the metadata block of your files.\n\nTo use your styles, your source files need to have a metadata block. These commands in the block are recognized by this script:\n\n- styles: A list of styles to be used for the file\n- style-defintion: In addition of defining styles in the "styles.yaml" file, you can define a style here too. Style settings given here have precedence over those given in "styles.yaml"\n- formats: A list of formats the source file should be converted to. If none is given, html- and pdf-files are build.\n- destination: A directory to create the output in.\n- output-name: The desired name of the outputfile without extension. In none is given, the filename is used.\n- fields that exist in the style. They override the default given in the style.\n\nIf you convert all files in a folder as one document, these additional commands are available:\n\n- file-list: Specify exactly which files in the folder should be converted.\n- excluded-files: Exclude the listed files from beeing converted.\n\nThen to convert your file, open the console and enter:\n\n    pandoc-styles "your_file"\n\nOr if you want to convert all files in a folder as one document:\n    pandoc-styles -f\n\nThe commandline script has many optional parameters to be useful in macros, batch files etc. Enter\n\n    pandoc-styles -h\n\nto see all the options.\n\n## Defining Styles\n\n### Basic Usage\n\nStyles are written in yaml, just like pandoc metadata-blocks. A style is defined like this:\n\n~~~yaml\nName:\n  format:\n      pandoc-option: value\n      pandoc-variable: value\n~~~\n\n"Name" is how the style is adressed. A style directly defined in the metadata-block has no name. "Format" specifies for which format the following commands should be invoked. There is a special value: "all". Everything under "all" is used in any format. Examples for formats are html, pdf, latex, epub etc.\n\nUnder the format you just enter pandoc options and variables. If a parameter is a flag, use "true". Parameters given the value "false" are ignored.\n\n**A Basic example**\n\nThis is an example metadata-block in a source file:\n\n~~~yaml\n\n---\ntitle:  Example\nauthor: John Doe\nformats:\n    - html\n    - pdf\nstyle-definition:\n    all:\n        toc: true\n        toc-depth: 3\n        highlight-style: tango\n        language: en\n    html:\n        standalone: true\n    pdf:\n        pdf-engine: xelatex\n---\n~~~\n\n### Inheritance\n\nA style can have a field named "inherit". This is a list of other styles it inherits from. Styles lower on the list update styles that are higher. The following rules are in place:\n\n- Single values are replaced\n- If a value is another dictionary, new values are appended to it, if a value exists, these rules are used again on it\n- If a value is a list, new values are appended to it.\n\n## Stylepacks\n\nIt is possible, to bundle all files necessary for a particular style and share this as a stylepack. You can install a stylepack either through extracting its contents into the styles folder inside the config folder or through the pandoc_styles_tools command line interface with the option `import` command.\n\nTo use a stylepack, include a field "stylepacks" in the matadata. It looks like this:\n\n~~~\nstylepacks:\n  - stylepack_1_name:\n    - style_1\n    - style2\n  - stylepack_2_name\n~~~\n\nIf you do not specify styles from the stylepack, it uses its default style.\n\n**Example**\n\n[pandoc_styles: novel](https://github.com/dickloraine/pandoc_styles_novel) is a stylepack to create novels out of your source files. A documentation for using this stylepack is found on the github page and inside the style folder of the pack once installed. You can install it with this command:\n\n~~~\npandoc-styles-tools import novel -u https://github.com/dickloraine/pandoc_styles_novel/releases/latest/download/novel.zip\n~~~\n\n## Advanced Feature\n\n### Adressing files in the configuration folder\n\nYou can point to a file in the configuration directory, if you prepend the path with "~/". The script searches first for the given path and then looks in appropiatly named subfolders and finally in the "misc" subfolder. For example:\n\n~~~yaml\nfilter:\n  - ~/test-filter.py\n~~~\n\nWould find the file "test-filter.py" in the subfolder "filter" in the configuration directory.\n\n### Verbatim Variables\n\nIf you need template variables that should not be rendered in the output format (for example file paths), you can add these under the "verbatim-variables" field:\n\n~~~yaml\nverbatim-variables:\n  my-path: "my/path"\n~~~\n\nSome variables are predefiened and always usable in templates:\n\n- config-dir: The path to the config dir\n- stylepackName-dir: The path to the directory of the given stylepack\n- temp-dir: The path to the currently used temporary directory\n\n### Preflight\n\nYou can run other command-line apps and scripts before the conversion happens. Just enter the command-line command in the preflight field in the style definition. You can pass the files list to it with `<files>`. Explicitly mark the value as a string, to avoid any hassle with special characters. For example:\n\n~~~yaml\nTest-style:\n  html:\n    preflight:\n      - \'some_app -d -f <files>\'\n~~~\n\nIf you give it just a single python file, it assumes that it is a special preflight script. These are written in python and have access to the style infos and files that should be converted.\n\nHere a basic example of a preflight script, that appends text given in the field "append-to-file" in the style definition to the end of the files:\n\n~~~python\nfrom pandoc_styles import run_preflight_script, file_read, file_write\n\n\ndef preflight(self):\n    text_to_append = self.cfg["append-to-file"]\n    if isinstance(text_to_append, list):\n        text_to_append = "\\n".join(text_to_append)\n    file_write(self.files[-1], f"{file_read(self.files[-1])}\\n{text_to_append}")\n\n\nif __name__ == \'__main__\':\n    run_preflight_script(preflight)\n~~~\n\nModify only the preflight function to include your code.\n\nAnd to run it in your style definition:\n\n~~~yaml\nTest-style:\n  html:\n    preflight:\n      - append-to-file.py\n    append-to-file: "Test"\n~~~\n\n### Process Sass\n\nYou can point to sass-files that should be used for html output and this script converts them for you to css and uses that in the output. In addition you can define variables used in the sass file and specify, where the compiled css file shoud be copied.\n\n~~~yaml\nTest-style:\n  html:\n    sass:\n      files: ~/default.scss\n      output-path: temp\n      variables:\n        body-font-size: 10pt\n~~~\n\n"files" is a list of sass files to be included.\n\n"output-path" can be "~/" to output to the css folder in the configuration folder, a relative path or "temp" to be used with the "self-contained" parameter. If ommited, the css output is in the same folder as the source files output.\n\n"variables" can be any variables in your sass files.\n\n### Add to template\n\nSometimes you want to include some code directly into the template, instead of just including it in the header. Mostly, if you want to define and use your own template variables.\n\nThis option just injects the given code directly into the head of the template.\n\nIt accepts a path to a file and will add the contents of the file to the template.\n\n~~~yaml\nTest-style:\n  pdf:\n    add-to-template:\n      - |\n        \\titlehead{{$titletop-left$\n        \\hfill $titletop-right$\\\\}\n        $titlehead$}\n        \\publishers{\\small $titlebottom$}\n~~~\n\n### Replace in template\n\nAs above, but instead of just adding the code to the head, it replaces arbitrary text in the template. You need to give it a pattern and a replacement text. Optionally you can use the flag "add" to not replace the text, but prepend to it and the field "count" if only some matches should be replaced.\n\n~~~yaml\nTest-style:\n  html:\n    replace-in-template:\n      - pattern: \\$body\\$\n        replacement-text: |\n          <div class="content">\n          $body$\n          </div>\n~~~\n\n### Replace in output\n\nExactly the same as replace-in-template but for text in the output-file\n\n### Postflight\n\nThese scripts are called after the source is converted. Pretty similar to preflight, but instead of `<files>` it only accepts a single `<file>`\n\n**Some app:**\n\n~~~yaml\nTest-style:\n  html:\n    preflight:\n      - \'some_app -d -f <file>\'\n~~~\n\n**Custome script:**\n\n~~~python\nfrom pandoc_styles import run_postflight_script, file_read, file_write\n\n\ndef postflight(self):\n    text_to_append = self.cfg["append-to-output"]\n    if isinstance(text_to_append, list):\n        text_to_append = "\\n".join(text_to_append)\n    file_write(ffile, f"{file_read(ffile)}\\n{text_to_append}")\n\n\nif __name__ == \'__main__\':\n    run_postflight_script(postflight)\n~~~\n\n~~~yaml\nTest-style:\n  html:\n    preflight:\n      - append-to-output.py\n    append-to-output: "Test"\n~~~\n\n### Filter\n\nThis script includes some functionality to make writing filters a little bit more easy.\n\n### Advanced Example\n\nPandocs self-contained flag doesn\'t work for html if math is used, because mathjax can\'t be included. This style is not really self-contained, but it allows for single files with all css included. This example useses the default.sass file included in this script. Fonts are also just referenced instead of included, to make for small file-sizes.\n\nFor code in pdfs, it introduces line-wrap in code blocks and ligatures in the font.\n\nIn addition, inheritance is shown.\n\n~~~yaml\nAll:\n  all:\n    lang: en\n  pdf:\n    pdf-engine: "xelatex"\n\nMath-document:\n  inherits:\n    - Code\n  html:\n    self-contained: true\n    mathjax: true\n    sass:\n      files: ~/default.scss\n      output-path: temp\n    replace-in-template:\n      - pattern: \\$body\\$\n        replacement-text: |\n          <div class="content">\n          $body$\n          </div>\n      - pattern: \\$table-of-contents\\$\n        replacement-text: |\n          <div id="sidebar">\n          <input class="trigger" type="checkbox" id="mainNavButton">\n          <label for="mainNavButton" onclick></label>\n          $table-of-contents$\n          </div>\n    replace-in-output:\n      - pattern: (<\\/head>)\n        count: 1\n        add: true\n        replacement-text: |\n          <link href="https://fonts.googleapis.com/css?family=Noto+Sans|Noto+Serif|Oswald" rel="stylesheet">\n          <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/tonsky/FiraCode@1.206/distr/fira_code.css">\n      - pattern: <script type="text\\/javascript">\\/\\*\\n\\s+\\*\\s+\\/MathJax\\.js.*?<\\/script>\n        replacement-text: |\n          <script src="https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.2/MathJax.js?config=TeX-AMS_CHTML-full" type="text/javascript"></script>\n\nCode:\n  all:\n    highlight-style: tango\n  pdf:\n    monofont: Fira Code\n    # allow code line break\n    add-to-template:\n      - |\n        \\usepackage{fvextra}\n        \\DefineVerbatimEnvironment{Highlighting}{Verbatim}{breaklines,breakautoindent=true,commandchars=\\\\\\{\\}}\n      - |\n        \\setmonofont[\n          Contextuals={Alternate}\n        ]{$monofont$}\n        \\makeatletter\n        \\def\\verbatim@nolig@list{}\n        \\makeatother\n~~~\n\n## Commandline tools\n\nSome additional tools are available on the commandline with the command:\n\n```bash\npandoc-styles-tools\n```\n\nThe import option is used to import stylepacks.\n\nOne tool merges styles and outputs the new style in a file.\n\nThe localize tool copies all used assets into the local directory, to have a self-contingent project folder.\n\n## Creating stylepacks\n\nTo create a stylepack, just create a folder with the name of the stylepack. Inside the folder put a yaml file containing the style definitions with the name of the stylepack. Then mimick the config folder for organizing the files provided.\n\nIn the yaml file reference links to files inside the stylepack with "stylepack_name@path".\n\nCreate a zip of your folder (with the folder inside the zip) and name it after your stylepack.\n',
    'author': 'dickloraine',
    'author_email': 'dickloraine@gmx.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dickloraine/pandoc_styles',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
