from typing_extensions import Final, TypeAlias

from Xlib.protocol import rq

class AnyEvent(rq.Event): ...
class KeyButtonPointer(rq.Event): ...
class KeyPress(KeyButtonPointer): ...
class KeyRelease(KeyButtonPointer): ...
class ButtonPress(KeyButtonPointer): ...
class ButtonRelease(KeyButtonPointer): ...
class MotionNotify(KeyButtonPointer): ...
class EnterLeave(rq.Event): ...
class EnterNotify(EnterLeave): ...
class LeaveNotify(EnterLeave): ...
class Focus(rq.Event): ...
class FocusIn(Focus): ...
class FocusOut(Focus): ...
class Expose(rq.Event): ...
class GraphicsExpose(rq.Event): ...
class NoExpose(rq.Event): ...
class VisibilityNotify(rq.Event): ...
class CreateNotify(rq.Event): ...
class DestroyNotify(rq.Event): ...
class UnmapNotify(rq.Event): ...
class MapNotify(rq.Event): ...
class MapRequest(rq.Event): ...
class ReparentNotify(rq.Event): ...
class ConfigureNotify(rq.Event): ...
class ConfigureRequest(rq.Event): ...
class GravityNotify(rq.Event): ...
class ResizeRequest(rq.Event): ...
class Circulate(rq.Event): ...
class CirculateNotify(Circulate): ...
class CirculateRequest(Circulate): ...
class PropertyNotify(rq.Event): ...
class SelectionClear(rq.Event): ...
class SelectionRequest(rq.Event): ...
class SelectionNotify(rq.Event): ...
class ColormapNotify(rq.Event): ...
class MappingNotify(rq.Event): ...
class ClientMessage(rq.Event): ...
class KeymapNotify(rq.Event): ...

_EventClass: TypeAlias = dict[
    int,
    type[KeyPress]
    | type[KeyRelease]
    | type[ButtonPress]
    | type[ButtonRelease]
    | type[MotionNotify]
    | type[EnterNotify]
    | type[LeaveNotify]
    | type[FocusIn]
    | type[FocusOut]
    | type[KeymapNotify]
    | type[Expose]
    | type[GraphicsExpose]
    | type[NoExpose]
    | type[VisibilityNotify]
    | type[CreateNotify]
    | type[DestroyNotify]
    | type[UnmapNotify]
    | type[MapNotify]
    | type[MapRequest]
    | type[ReparentNotify]
    | type[ConfigureNotify]
    | type[ConfigureRequest]
    | type[GravityNotify]
    | type[ResizeRequest]
    | type[CirculateNotify]
    | type[CirculateRequest]
    | type[PropertyNotify]
    | type[SelectionClear]
    | type[SelectionRequest]
    | type[SelectionNotify]
    | type[ColormapNotify]
    | type[ClientMessage]
    | type[MappingNotify],
]
event_class: Final[_EventClass]
