import pathlib

from setuptools import setup

here = pathlib.Path(__file__).parent.resolve()

install_requires = (
    here / 'src' / 'fallible' / '_vendor' / 'ansible' / 'requirements.txt'
).read_text(encoding='utf-8').splitlines()

setup(
    install_requires=install_requires,
    entry_points={
        'console_scripts': [
            'fallible=fallible._vendor.ansible.lib.ansible.cli.adhoc:main',
            'fallible-config=fallible._vendor.ansible.lib.ansible.cli.config:main',
            'fallible-console=fallible._vendor.ansible.lib.ansible.cli.console:main',
            'fallible-doc=fallible._vendor.ansible.lib.ansible.cli.doc:main',
            'fallible-galaxy=fallible._vendor.ansible.lib.ansible.cli.galaxy:main',
            'fallible-inventory=fallible._vendor.ansible.lib.ansible.cli.inventory:main',
            'fallible-playbook=fallible._vendor.ansible.lib.ansible.cli.playbook:main',
            'fallible-pull=fallible._vendor.ansible.lib.ansible.cli.pull:main',
            'fallible-vault=fallible._vendor.ansible.lib.ansible.cli.vault:main',
            'fallible-connection=fallible._vendor.ansible.lib.ansible.cli.scripts.ansible_connection_cli_stub:main',
            'fallible-test=fallible._vendor.ansible.test.lib.ansible_test._util.target.cli.ansible_test_cli_stub:main',
        ]
    },
)
