"""Module for light strip effects (LB*, KL*, KB*)."""

from typing import List, cast

EFFECT_AURORA = {
    "custom": 0,
    "id": "xqUxDhbAhNLqulcuRMyPBmVGyTOyEMEu",
    "brightness": 100,
    "name": "Aurora",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "sequence",
    "duration": 0,
    "transition": 1500,
    "direction": 4,
    "spread": 7,
    "repeat_times": 0,
    "sequence": [[120, 100, 100], [240, 100, 100], [260, 100, 100], [280, 100, 100]],
}
EFFECT_BUBBLING_CAULDRON = {
    "custom": 0,
    "id": "tIwTRQBqJpeNKbrtBMFCgkdPTbAQGfRP",
    "brightness": 100,
    "name": "Bubbling Cauldron",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [100, 270],
    "saturation_range": [80, 100],
    "brightness_range": [50, 100],
    "duration": 0,
    "transition": 200,
    "init_states": [[270, 100, 100]],
    "fadeoff": 1000,
    "random_seed": 24,
    "backgrounds": [[270, 40, 50]],
}
EFFECT_CANDY_CANE = {
    "custom": 0,
    "id": "HCOttllMkNffeHjEOLEgrFJjbzQHoxEJ",
    "brightness": 100,
    "name": "Candy Cane",
    "segments": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "sequence",
    "duration": 700,
    "transition": 500,
    "direction": 1,
    "spread": 1,
    "repeat_times": 0,
    "sequence": [
        [0, 0, 100],
        [0, 0, 100],
        [360, 81, 100],
        [0, 0, 100],
        [0, 0, 100],
        [360, 81, 100],
        [360, 81, 100],
        [0, 0, 100],
        [0, 0, 100],
        [360, 81, 100],
        [360, 81, 100],
        [360, 81, 100],
        [360, 81, 100],
        [0, 0, 100],
        [0, 0, 100],
        [360, 81, 100],
    ],
}
EFFECT_CHRISTMAS = {
    "custom": 0,
    "id": "bwTatyinOUajKrDwzMmqxxJdnInQUgvM",
    "brightness": 100,
    "name": "Christmas",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [136, 146],
    "saturation_range": [90, 100],
    "brightness_range": [50, 100],
    "duration": 5000,
    "transition": 0,
    "init_states": [[136, 0, 100]],
    "fadeoff": 2000,
    "random_seed": 100,
    "backgrounds": [[136, 98, 75], [136, 0, 0], [350, 0, 100], [350, 97, 94]],
}
EFFECT_FLICKER = {
    "custom": 0,
    "id": "bCTItKETDFfrKANolgldxfgOakaarARs",
    "brightness": 100,
    "name": "Flicker",
    "segments": [1],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [30, 40],
    "saturation_range": [100, 100],
    "brightness_range": [50, 100],
    "duration": 0,
    "transition": 0,
    "transition_range": [375, 500],
    "init_states": [[30, 81, 80]],
}
EFFECT_HANUKKAH = {
    "custom": 0,
    "id": "CdLeIgiKcQrLKMINRPTMbylATulQewLD",
    "brightness": 100,
    "name": "Hanukkah",
    "segments": [1],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [200, 210],
    "saturation_range": [0, 100],
    "brightness_range": [50, 100],
    "duration": 1500,
    "transition": 0,
    "transition_range": [400, 500],
    "init_states": [[35, 81, 80]],
}
EFFECT_HAUNTED_MANSION = {
    "custom": 0,
    "id": "oJnFHsVQzFUTeIOBAhMRfVeujmSauhjJ",
    "brightness": 80,
    "name": "Haunted Mansion",
    "segments": [80],
    "expansion_strategy": 2,
    "enable": 1,
    "type": "random",
    "hue_range": [45, 45],
    "saturation_range": [10, 10],
    "brightness_range": [0, 80],
    "duration": 0,
    "transition": 0,
    "transition_range": [50, 1500],
    "init_states": [[45, 10, 100]],
    "fadeoff": 200,
    "random_seed": 1,
    "backgrounds": [[45, 10, 100]],
}
EFFECT_ICICLE = {
    "custom": 0,
    "id": "joqVjlaTsgzmuQQBAlHRkkPAqkBUiqeb",
    "brightness": 70,
    "name": "Icicle",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "sequence",
    "duration": 0,
    "transition": 400,
    "direction": 4,
    "spread": 3,
    "repeat_times": 0,
    "sequence": [
        [190, 100, 70],
        [190, 100, 70],
        [190, 30, 50],
        [190, 100, 70],
        [190, 100, 70],
    ],
}
EFFECT_LIGHTNING = {
    "custom": 0,
    "id": "ojqpUUxdGHoIugGPknrUcRoyJiItsjuE",
    "brightness": 100,
    "name": "Lightning",
    "segments": [7, 20, 23, 32, 34, 35, 49, 65, 66, 74, 80],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [240, 240],
    "saturation_range": [10, 11],
    "brightness_range": [90, 100],
    "duration": 0,
    "transition": 50,
    "init_states": [[240, 30, 100]],
    "fadeoff": 150,
    "random_seed": 600,
    "backgrounds": [[200, 100, 100], [200, 50, 10], [210, 10, 50], [240, 10, 0]],
}
EFFECT_OCEAN = {
    "custom": 0,
    "id": "oJjUMosgEMrdumfPANKbkFmBcAdEQsPy",
    "brightness": 30,
    "name": "Ocean",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "sequence",
    "duration": 0,
    "transition": 2000,
    "direction": 3,
    "spread": 16,
    "repeat_times": 0,
    "sequence": [[198, 84, 30], [198, 70, 30], [198, 10, 30]],
}
EFFECT_RAINBOW = {
    "custom": 0,
    "id": "izRhLCQNcDzIKdpMPqSTtBMuAIoreAuT",
    "brightness": 100,
    "name": "Rainbow",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "sequence",
    "duration": 0,
    "transition": 1500,
    "direction": 1,
    "spread": 12,
    "repeat_times": 0,
    "sequence": [[0, 100, 100], [100, 100, 100], [200, 100, 100], [300, 100, 100]],
}
EFFECT_RAINDROP = {
    "custom": 0,
    "id": "QbDFwiSFmLzQenUOPnJrsGqyIVrJrRsl",
    "brightness": 30,
    "name": "Raindrop",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [200, 200],
    "saturation_range": [10, 20],
    "brightness_range": [10, 30],
    "duration": 0,
    "transition": 1000,
    "init_states": [[200, 40, 100]],
    "fadeoff": 1000,
    "random_seed": 24,
    "backgrounds": [[200, 40, 0]],
}
EFFECT_SPRING = {
    "custom": 0,
    "id": "URdUpEdQbnOOechDBPMkKrwhSupLyvAg",
    "brightness": 100,
    "name": "Spring",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [0, 90],
    "saturation_range": [30, 100],
    "brightness_range": [90, 100],
    "duration": 600,
    "transition": 0,
    "transition_range": [2000, 6000],
    "init_states": [[80, 30, 100]],
    "fadeoff": 1000,
    "random_seed": 20,
    "backgrounds": [[130, 100, 40]],
}
EFFECT_VALENTINES = {
    "custom": 0,
    "id": "QglBhMShPHUAuxLqzNEefFrGiJwahOmz",
    "brightness": 100,
    "name": "Valentines",
    "segments": [0],
    "expansion_strategy": 1,
    "enable": 1,
    "type": "random",
    "hue_range": [340, 340],
    "saturation_range": [30, 40],
    "brightness_range": [90, 100],
    "duration": 600,
    "transition": 2000,
    "init_states": [[340, 30, 100]],
    "fadeoff": 3000,
    "random_seed": 100,
    "backgrounds": [[340, 20, 50], [20, 50, 50], [0, 100, 50]],
}

EFFECTS_LIST_V1 = [
    EFFECT_AURORA,
    EFFECT_BUBBLING_CAULDRON,
    EFFECT_CANDY_CANE,
    EFFECT_CHRISTMAS,
    EFFECT_FLICKER,
    EFFECT_HANUKKAH,
    EFFECT_HAUNTED_MANSION,
    EFFECT_ICICLE,
    EFFECT_LIGHTNING,
    EFFECT_OCEAN,
    EFFECT_RAINBOW,
    EFFECT_RAINDROP,
    EFFECT_SPRING,
    EFFECT_VALENTINES,
]

EFFECT_NAMES_V1: List[str] = [cast(str, effect["name"]) for effect in EFFECTS_LIST_V1]
EFFECT_MAPPING_V1 = {effect["name"]: effect for effect in EFFECTS_LIST_V1}
