
This is just a wrapper around pytube with some extra functionality hacked 
on top, it's quick and dirty but gives me the features I'm missing from pytube

## Channel Playlists

Extract playlists from a channel

```python
from tutubo.models import Channel

url = "https://www.youtube.com/channel/UC4BSeEq7XNtihGqI309vhYg"
c = Channel(url)
for pl in c.playlists:
    for video in pl.videos:
        print(video.title)
```

## Search

Faster (avoid parsing of individual urls) and more advanced (not only videos)

```python
from tutubo import YoutubeSearch
from tutubo.models import *


def search_yt(query, parse=False):
    res = {
        'channels': [],
        'playlists': [],
        'mix': [],
        'related_queries': [],
        'related_videos': [],
        'videos': []
    }

    s = YoutubeSearch(query, preview=not parse)
    for v in s.iterate_youtube():
        if isinstance(v, YoutubeMixPreview):
            pl = {'playlistId': v.playlist_id,
                  'title': v.title,
                  'url': v.playlist_url,
                  "image": v.thumbnail_url,
                  'featured_videos': v.featured_videos}
            res["mix"].append(pl)
        elif isinstance(v, RelatedSearch):
            pl = {'query': v.query,
                  'image': v.thumbnail_url}
            res["related_queries"].append(pl)
        elif isinstance(v, ChannelPreview) or isinstance(v, Channel):
            pl = {'channelId': v.channel_id,
                  'title': v.title,
                  'image': v.thumbnail_url,
                  'url': v.channel_url}
            res["channels"].append(pl)
        elif isinstance(v, PlaylistPreview) or isinstance(v, Playlist):
            pl = {'playlistId': v.playlist_id,
                  'title': v.title,
                  'url': v.playlist_url,
                  "image": v.thumbnail_url,
                  'featured_videos': v.featured_videos}
            res["playlists"].append(pl)
        elif isinstance(v, RelatedVideoPreview) or isinstance(v, RelatedVideo):
            vid = {'length': v.length,
                   'keywords': v.keywords,
                   'image': v.thumbnail_url,
                   'title': v.title,
                   "author": v.author,
                   'url': v.watch_url,
                   'videoId': v.video_id}
            res["related_videos"].append(vid)
        else:
            vid = {'length': v.length,
                   'keywords': v.keywords,
                   'image': v.thumbnail_url,
                   'title': v.title,
                   "author": v.author,
                   'url': v.watch_url,
                   'videoId': v.video_id}
            res["videos"].append(vid)

    return res


res = search_yt("rob zombie", parse=False)
print(res)
"""
{'channels': [{'channelId': 'UChWc6ilKdVM1Cz--wGMW_Zg',
               'image': 'https://i.ytimg.com/vi/aQxaGpJNfyA/sddefault.jpg',
               'title': 'Rob Zombie',
               'url': 'https://www.youtube.com/channel/UChWc6ilKdVM1Cz--wGMW_Zg'}],
 'mix': [],
 'playlists': [{'featured_videos': [{'image': 'https://i.ytimg.com/vi/LW9ZGT8L7ZA/hqdefault.jpg',
                                     'title': 'Rob Zombie - More Human than '
                                              'Human',
                                     'url': 'https://youtube.com/watch?v=LW9ZGT8L7ZA',
                                     'videoId': 'LW9ZGT8L7ZA'},
                                    {'image': 'https://i.ytimg.com/vi/vV0NoICl7cE/sddefault.jpg',
                                     'title': 'Rob Zombie - Lords Of Salem',
                                     'url': 'https://youtube.com/watch?v=vV0NoICl7cE',
                                     'videoId': 'vV0NoICl7cE'},
                                    {'image': 'https://i.ytimg.com/vi/LmXdpv3pCGU/sddefault.jpg',
                                     'title': 'Rob Zombie - Foxy, Foxy',
                                     'url': 'https://youtube.com/watch?v=LmXdpv3pCGU',
                                     'videoId': 'LmXdpv3pCGU'},
                                    {'image': 'https://i.ytimg.com/vi/AeUwikDrA9I/hqdefault.jpg',
                                     'title': 'Rob Zombie - Sick Bubblegum',
                                     'url': 'https://youtube.com/watch?v=AeUwikDrA9I',
                                     'videoId': 'AeUwikDrA9I'},
                                    {'image': 'https://i.ytimg.com/vi/BvsMPOfblfg/sddefault.jpg',
                                     'title': 'Rob Zombie - Living Dead Girl '
                                              '(Official Video)',
                                     'url': 'https://youtube.com/watch?v=BvsMPOfblfg',
                                     'videoId': 'BvsMPOfblfg'},
                                    {'image': 'https://i.ytimg.com/vi/MdKXShP_oc4/sddefault.jpg',
                                     'title': 'Rob Zombie - American Witch',
                                     'url': 'https://youtube.com/watch?v=MdKXShP_oc4',
                                     'videoId': 'MdKXShP_oc4'}],
                'image': 'https://i.ytimg.com/vi/LW9ZGT8L7ZA/hqdefault.jpg',
                'playlistId': 'PLBxwSF9JxLuJea2Hn2b_xw-3X7IAfBMZT',
                'title': 'Rob Zombie Greatest Hits',
                'url': 'https://www.youtube.com/playlist?list=PLBxwSF9JxLuJea2Hn2b_xw-3X7IAfBMZT'},
               {'featured_videos': [{'image': 'https://i.ytimg.com/vi/EqQuihD0hoI/sddefault.jpg',
                                     'title': 'Rob Zombie - Dragula (Official '
                                              'Video)',
                                     'url': 'https://youtube.com/watch?v=EqQuihD0hoI',
                                     'videoId': 'EqQuihD0hoI'},
                                    {'image': 'https://i.ytimg.com/vi/uHBtpqbOKXk/sddefault.jpg',
                                     'title': 'Rob Zombie - Superbeast '
                                              '(Official Video)',
                                     'url': 'https://youtube.com/watch?v=uHBtpqbOKXk',
                                     'videoId': 'uHBtpqbOKXk'},
                                    {'image': 'https://i.ytimg.com/vi/BvsMPOfblfg/sddefault.jpg',
                                     'title': 'Rob Zombie - Living Dead Girl '
                                              '(Official Video)',
                                     'url': 'https://youtube.com/watch?v=BvsMPOfblfg',
                                     'videoId': 'BvsMPOfblfg'},
                                    {'image': 'https://i.ytimg.com/vi/0698sTH7mUk/sddefault.jpg',
                                     'title': 'Rob Zombie - Never Gonna Stop '
                                              '(The Red Red Kroovy) [Official '
                                              'Video]',
                                     'url': 'https://youtube.com/watch?v=0698sTH7mUk',
                                     'videoId': '0698sTH7mUk'},
                                    {'image': 'https://i.ytimg.com/vi/VK16w_Esrno/sddefault.jpg',
                                     'title': 'Rob Zombie - Feel So Numb',
                                     'url': 'https://youtube.com/watch?v=VK16w_Esrno',
                                     'videoId': 'VK16w_Esrno'},
                                    {'image': 'https://i.ytimg.com/vi/AeUwikDrA9I/hqdefault.jpg',
                                     'title': 'Rob Zombie - Sick Bubblegum',
                                     'url': 'https://youtube.com/watch?v=AeUwikDrA9I',
                                     'videoId': 'AeUwikDrA9I'}],
                'image': 'https://i.ytimg.com/vi/EqQuihD0hoI/sddefault.jpg',
                'playlistId': 'PL9E5EE14539AE3644',
                'title': 'rob zombie playlist',
                'url': 'https://www.youtube.com/playlist?list=PL9E5EE14539AE3644'}],
 'related_queries': [{'image': 'https://lh3.googleusercontent.com/ETMD6CHtBUxRGwcL4XSVSUV_9l7eN7hWNGzxlyYnx2fKm_jlA-BI9A2175t6C5WgjguGQ8DfqxuUxw=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'White Zombie'},
                     {'image': 'https://lh3.googleusercontent.com/JVofoNggGyrfCgKRyEB1u6J1MfBZq01mwklJkKJfzEpjfvRtIShxFDoKyWlAI2QSKvPrsZlZcRwcl8g=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Alice Cooper'},
                     {'image': 'https://lh3.googleusercontent.com/NmO-ZmjNGKgUgJ_O_LUvqfWAsZoPLXl6bPFXbB5OAgx5e-AZ_lLMcVAAXckviKuxNLE9iJNSNwOVv3w=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'John Carpenter'},
                     {'image': 'https://lh3.googleusercontent.com/gGnVSqeNBa_4NBsdCU4Kth1ys9IaYksP7zJ5Z3NibAUl-WCBiP8WRB2MkeT7rtm0-Or7W3yUznFJZt0=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Ozzy Osbourne'},
                     {'image': 'https://lh3.googleusercontent.com/TbLnMOoZTmsrVB0J2zpUfJGgYmjOE1xmCJ55LUuX02qlMET3CMxe527vEjo4z2miU99xh9ih8aMs9v4=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Korn'},
                     {'image': 'https://lh3.googleusercontent.com/Q52kGHt-AadkWqya2rDgaLUc2f9IubxH4b53xBqo-vm5CqHwBtdKVFSGfol8m_mp03GoMp_rFBEKS6Q=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Five Finger Death Punch'},
                     {'image': 'https://lh3.googleusercontent.com/KnByTUXJkfrqlDoS4LXhyRFZALhxmHOfBtI9FLHtb1g5OB5msMdHXHcISvwtQGNtzwXKqjDmIw=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Metallica'},
                     {'image': 'https://lh3.googleusercontent.com/EGPOFCUL__GQlZRipF2G6xW2gtTS6I0RMzo4BRMXN999LkUivh1tCqjChl_ozt307Tsr7zkr_EO_BV4=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Rammstein'},
                     {'image': 'https://lh3.googleusercontent.com/vtdkFSDCcM-E5FGhxSkfrrUDmTNi0CZsJ6nwHSD2c9huoAWaasTVIIa0ahnqLq6yKYyv2a4fy5r_Y5E=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Limp Bizkit'},
                     {'image': 'https://lh3.googleusercontent.com/FoKvE1wvP7_VE2ptVCXpXZFqYfQofDCMGlGGy34H0tkxI3bepxmE9Te2A1tNQxz5nqe6y7YEPzGMfWo=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Corey Taylor'},
                     {'image': 'https://lh3.googleusercontent.com/qKUqNV8FpS5F1MHcG02KSeuAt_4x0XBezv5zpkQYpIMxK0FiGejB0TKJHgu_tfXGCbaVxodtXg=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Godsmack'},
                     {'image': 'https://lh3.googleusercontent.com/ibQTCmj8X8vii6Im2bU8PUqncaGz_I3kC2_cykRaJn63efnpAFDG3WN52CKjWQuqN1_EkjMlBHCYaCo=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Marilyn Manson'},
                     {'image': 'https://lh3.googleusercontent.com/ydf-77N5ZOaL39t57-bd0cby7qILKibyjnU2ma1b1xk9DDqLOw_2WqjymTmFJx9LSVQRSs2eQPc6IHNN=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Powerman 5000'},
                     {'image': 'https://lh3.googleusercontent.com/39FCQfKPhumhYwqFpZuVFKqdmd3DdKGnFbEQqrLgMvh-nUBkg2rmmGX7k7u9M3CW_SkM7N66cU7gJ8s=w320-h180-p-k-c0x00ffffff-no-rj-mo',
                      'query': 'Gene Simmons'}],
 'related_videos': [{'author': 'RobZombieVEVO',
                     'image': 'https://i.ytimg.com/vi/LmXdpv3pCGU/sddefault.jpg',
                     'keywords': ['Rob', 'Zombie', 'Geffen', 'Rock'],
                     'length': 216,
                     'title': 'Rob Zombie - Foxy, Foxy',
                     'url': 'https://youtube.com/watch?v=LmXdpv3pCGU',
                     'videoId': 'LmXdpv3pCGU'},
                    {'author': 'CayugaHoodRat',
                     'image': 'https://i.ytimg.com/vi/nkiAKFfqIxg/sddefault.jpg',
                     'keywords': ['Rob zombie',
                                  'Halloween',
                                  'full movie',
                                  'english',
                                  'michael myers'],
                     'length': 6605,
                     'title': "Rob Zombie's Halloween (2007) Full Movie",
                     'url': 'https://youtube.com/watch?v=nkiAKFfqIxg',
                     'videoId': 'nkiAKFfqIxg'},
                    {'author': 'HorrorSoundtrack',
                     'image': 'https://i.ytimg.com/vi/RDMmzCK6vjA/sddefault.jpg',
                     'keywords': ['Rob Zombie',
                                  'House of 1000 Corpses',
                                  'Pussy Liquor',
                                  'Soundtrack'],
                     'length': 298,
                     'title': 'Rob Zombie - Pussy Liquor (Soundtrack)',
                     'url': 'https://youtube.com/watch?v=RDMmzCK6vjA',
                     'videoId': 'RDMmzCK6vjA'},
                    {'author': 'Rob Zombie - Topic',
                     'image': 'https://i.ytimg.com/vi/9d28Jbx7q9Q/sddefault.jpg',
                     'keywords': ['Rob Zombie',
                                  'ロブゾンビ',
                                  'ロブ・ゾンビ',
                                  'House Of 1000 Corpses',
                                  'ハウス・オブ・１０００・コープス',
                                  'ハウス・オブ・1000・コープセズ'],
                     'length': 224,
                     'title': 'House Of 1000 Corpses (From "House Of 1000 '
                              'Corpses" Soundtrack)',
                     'url': 'https://youtube.com/watch?v=9d28Jbx7q9Q',
                     'videoId': '9d28Jbx7q9Q'},
                    {'author': 'Hollywood Scream',
                     'image': 'https://i.ytimg.com/vi/YOZG0o-ucNg/sddefault.jpg',
                     'keywords': [],
                     'length': 158,
                     'title': 'Rob Zombie - Everybody Scream',
                     'url': 'https://youtube.com/watch?v=YOZG0o-ucNg',
                     'videoId': 'YOZG0o-ucNg'},
                    {'author': 'Spaceuntravel',
                     'image': 'https://i.ytimg.com/vi/9T6PXX7X2ro/sddefault.jpg',
                     'keywords': ['#channel',
                                  '#alt.rock',
                                  '#metal',
                                  '#rock',
                                  '#alternative',
                                  '#modern',
                                  '#metalcore',
                                  '#posthardcore',
                                  'music',
                                  '#band',
                                  '#female',
                                  '#vocals',
                                  '#riserecords',
                                  '#brand',
                                  '#melodic',
                                  'hardcore',
                                  '#fearless records',
                                  '#concert',
                                  '#heavymetal',
                                  '#singer',
                                  '#progressivemetal',
                                  '#groovemetal',
                                  '#rockmusic',
                                  '#guitar',
                                  '#metalbands',
                                  '#guitarist',
                                  '#headbanger',
                                  '#acoustic',
                                  '#alternativemetal',
                                  'punk',
                                  'spaceuntravel',
                                  'bring me the horizon',
                                  'unfd',
                                  'sumerian records',
                                  'korn',
                                  'asking alexandria',
                                  'uncopyrighted rock',
                                  'epitaph records',
                                  'freak on a leash',
                                  'make me bad',
                                  'korn cover',
                                  'korn lyrics'],
                     'length': 321,
                     'title': 'Chaoseum - Smile Again (Official Music Video)',
                     'url': 'https://youtube.com/watch?v=9T6PXX7X2ro',
                     'videoId': '9T6PXX7X2ro'},
                    {'author': 'Powerman5000VEVO',
                     'image': 'https://i.ytimg.com/vi/lsV500W4BHU/sddefault.jpg',
                     'keywords': ['Powerman', '5000', 'GEFFEN', 'Rock'],
                     'length': 188,
                     'title': 'Powerman 5000 - When Worlds Collide',
                     'url': 'https://youtube.com/watch?v=lsV500W4BHU',
                     'videoId': 'lsV500W4BHU'},
                    {'author': 'DrowningPoolVEVO',
                     'image': 'https://i.ytimg.com/vi/04F4xlWSFh0/sddefault.jpg',
                     'keywords': ['Drowning', 'Pool', 'Bodies', '(Video)'],
                     'length': 220,
                     'title': 'Drowning Pool - Bodies',
                     'url': 'https://youtube.com/watch?v=04F4xlWSFh0',
                     'videoId': '04F4xlWSFh0'},
                    {'author': 'Rammstein Official',
                     'image': 'https://i.ytimg.com/vi/W3q8Od5qJio/sddefault.jpg',
                     'keywords': ['Rammstein',
                                  'Rammstein Official',
                                  'Official',
                                  'Official Video',
                                  'Rammstein Musik',
                                  'Rammstein Official Video',
                                  'Rammstein.Official',
                                  'Rammstein Channel',
                                  'Heavy',
                                  'Metal',
                                  'Germany',
                                  'Rammstein Video',
                                  'Du Hast',
                                  'Rammstein Du Hast',
                                  'Du Hast Video',
                                  'Rammstein Du Hast Video',
                                  'Rammstein Du Hast Official',
                                  'Neue Deutsche Härte (Musical Genre)',
                                  'Rammstein (Musical Group)',
                                  'Music Video (TV Genre)',
                                  'Rammstein (Composition)',
                                  'Music (TV Genre)'],
                     'length': 235,
                     'title': 'Rammstein - Du Hast (Official Video)',
                     'url': 'https://youtube.com/watch?v=W3q8Od5qJio',
                     'videoId': 'W3q8Od5qJio'},
                    {'author': 'Napalm Records',
                     'image': 'https://i.ytimg.com/vi/7iJ7oj-dAVY/sddefault.jpg',
                     'keywords': ['napalm records'],
                     'length': 197,
                     'title': 'MUSHROOMHEAD - Carry On (Official Video) | '
                              'Napalm Records',
                     'url': 'https://youtube.com/watch?v=7iJ7oj-dAVY',
                     'videoId': '7iJ7oj-dAVY'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/aQxaGpJNfyA/sddefault.jpg',
                     'keywords': ['3 From Hell',
                                  'Rob Zombie',
                                  'Movie Trailer',
                                  'Sheri Moon Zombie',
                                  'Sid Haig',
                                  'Bill Moseley',
                                  'Captain Spaulding',
                                  'Baby Firefly',
                                  'Otis Driftwood',
                                  'Free The Three',
                                  'The Devils Rejects',
                                  'House of 1000 Corpses'],
                     'length': 50,
                     'title': 'Rob Zombie’s Three From Hell - Teaser Trailer',
                     'url': 'https://youtube.com/watch?v=aQxaGpJNfyA',
                     'videoId': 'aQxaGpJNfyA'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/fGLjQCY3xB8/hqdefault.jpg',
                     'keywords': ['rob zombie',
                                  'marilyn manson',
                                  'twins of evil',
                                  'john 5',
                                  'piggy d',
                                  'zombie',
                                  'manson',
                                  'rock',
                                  'tour',
                                  'live nation'],
                     'length': 12,
                     'title': 'Twins of Evil - Hell Never Dies Tour 2019',
                     'url': 'https://youtube.com/watch?v=fGLjQCY3xB8',
                     'videoId': 'fGLjQCY3xB8'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/roEzVi7pU5E/sddefault.jpg',
                     'keywords': ['rob zombie',
                                  'marilyn manson',
                                  'twins of evil',
                                  'twins of evil tour',
                                  'live nation',
                                  'john five',
                                  'john 5',
                                  'rock',
                                  'metal',
                                  '2018',
                                  'white zombie',
                                  'korn',
                                  'danzig',
                                  'marilyn',
                                  'manson',
                                  'rob',
                                  'zombie',
                                  'punk',
                                  'music'],
                     'length': 253,
                     'title': 'Rob Zombie & Marilyn Manson Discuss The First '
                              "Time They Heard Each Other's Music",
                     'url': 'https://youtube.com/watch?v=roEzVi7pU5E',
                     'videoId': 'roEzVi7pU5E'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/FruOhKwrhvE/sddefault.jpg',
                     'keywords': ['rob zombie',
                                  'marilyn manson',
                                  'twins of evil',
                                  'twins of evil tour',
                                  'john 5',
                                  'john five',
                                  'rock',
                                  'metal',
                                  '2018',
                                  'live nation'],
                     'length': 177,
                     'title': 'Twins of Evil Tour – The Second Coming',
                     'url': 'https://youtube.com/watch?v=FruOhKwrhvE',
                     'videoId': 'FruOhKwrhvE'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/RGz9PwzWpHs/sddefault.jpg',
                     'keywords': ['rob zombie',
                                  'ASTRO-CREEP: 2000 LIVE',
                                  'riot fest',
                                  'riot fest 2016'],
                     'length': 27,
                     'title': 'Rob Zombie - ASTRO-CREEP: 2000 LIVE - OUT NOW!',
                     'url': 'https://youtube.com/watch?v=RGz9PwzWpHs',
                     'videoId': 'RGz9PwzWpHs'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/fLpbovD_0bM/sddefault.jpg',
                     'keywords': ['rob zombie',
                                  'ASTRO-CREEP: 2000 LIVE',
                                  'hellbilly deluxe',
                                  'american made music to strip by',
                                  'the sinister urger',
                                  'educated horses',
                                  'zombie live',
                                  'mondo sex head',
                                  'VENOMOUS RAT REGENERATION VENDOR',
                                  'SPOOKSHOW INTERNATIONAL LIVE',
                                  'THE ELECTRIC WARLOCK ACID WITCH SATANIC '
                                  'ORGY CELEBRATION DISPENSER',
                                  'rock',
                                  'metal'],
                     'length': 29,
                     'title': 'Rob Zombie - Vinyl Catalog - Available Now!',
                     'url': 'https://youtube.com/watch?v=fLpbovD_0bM',
                     'videoId': 'fLpbovD_0bM'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/DcokDm5O-lM/sddefault.jpg',
                     'keywords': ['rob zombie',
                                  'ASTRO-CREEP: 2000 LIVE',
                                  'hellbilly deluxe',
                                  'american made music to strip by',
                                  'the sinister urge',
                                  'educated horses',
                                  'zombie live',
                                  'hellbilly deluxe 2',
                                  'mondo sex head',
                                  'VENOMOUS RAT REGENERATION VENDOR',
                                  'SPOOKSHOW INTERNATIONAL LIVE',
                                  'THE ELECTRIC WARLOCK ACID WITCH SATANIC '
                                  'ORGY CELEBRATION DISPENSER'],
                     'length': 30,
                     'title': 'Rob Zombie Career Vinyl Box - OUT NOW!',
                     'url': 'https://youtube.com/watch?v=DcokDm5O-lM',
                     'videoId': 'DcokDm5O-lM'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/qxSHmr4JbV0/sddefault.jpg',
                     'keywords': ['rob zombie',
                                  'astro-creep: 2000 live',
                                  'hellbilly deluxe',
                                  'american made music to strip by',
                                  'the sinister urge',
                                  'educated horses',
                                  'zombie live',
                                  'hellbilly deluxe 2',
                                  'mondo sex head',
                                  'venemous rat regeneration vendor',
                                  'spookshow international live',
                                  'THE ELECTRIC WARLOCK ACID WITCH SATANIC '
                                  'ORGY CELEBRATION DISPENSER'],
                     'length': 102,
                     'title': 'Rob Zombie Career Vinyl Box Set - OUT NOW!',
                     'url': 'https://youtube.com/watch?v=qxSHmr4JbV0',
                     'videoId': 'qxSHmr4JbV0'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/S4tS-MaHEgc/sddefault.jpg',
                     'keywords': ['rob zombie', 'ASTRO-CREEP: 2000 LIVE'],
                     'length': 27,
                     'title': 'Rob Zombie - ASTRO-CREEP: 2000 LIVE - Available '
                              'March 30',
                     'url': 'https://youtube.com/watch?v=S4tS-MaHEgc',
                     'videoId': 'S4tS-MaHEgc'},
                    {'author': 'Rob Zombie',
                     'image': 'https://i.ytimg.com/vi/gGwDRAtHwow/sddefault.jpg',
                     'keywords': ['rob zombie',
                                  'ASTRO-CREEP: 2000 LIVE',
                                  'HELLBILLY DELUXE',
                                  'AMERICAN MADE MUSIC TO STRIP BY',
                                  'THE SINISTER URGE',
                                  'EDUCATED HORSES',
                                  'ZOMBIE LIVE',
                                  'MONDO SEX HEAD',
                                  'VENOMOUS RAT REGENERATION VENDOR',
                                  'SPOOKSHOW INTERNATIONAL LIVE',
                                  'THE ELECTRIC WARLOCK ACID WITCH SATANIC '
                                  'ORGY CELEBRATION DISPENSER'],
                     'length': 29,
                     'title': 'Rob Zombie - Vinyl Catalog - Available March 30',
                     'url': 'https://youtube.com/watch?v=gGwDRAtHwow',
                     'videoId': 'gGwDRAtHwow'}],
 'videos': [{'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/EqQuihD0hoI/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'GEFFEN',
                          'Metal',
                          'rob zombie dragula',
                          'rob zombie vevo'],
             'length': 229,
             'title': 'Rob Zombie - Dragula (Official Video)',
             'url': 'https://youtube.com/watch?v=EqQuihD0hoI',
             'videoId': 'EqQuihD0hoI'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/BvsMPOfblfg/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Geffen',
                          'Rock',
                          'Rob Zombie Living Dead Girl',
                          'Rob Zombie Vevo'],
             'length': 204,
             'title': 'Rob Zombie - Living Dead Girl (Official Video)',
             'url': 'https://youtube.com/watch?v=BvsMPOfblfg',
             'videoId': 'BvsMPOfblfg'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/ey-AmU6Nbgk/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Dead',
                          'City',
                          'Radio',
                          'And',
                          'The',
                          'New',
                          'Gods',
                          'Of',
                          'Supertown',
                          'UME',
                          'Rock'],
             'length': 212,
             'title': 'Rob Zombie - Dead City Radio And The New Gods Of '
                      'Supertown',
             'url': 'https://youtube.com/watch?v=ey-AmU6Nbgk',
             'videoId': 'ey-AmU6Nbgk'},
            {'author': 'Ita Depeeza',
             'image': 'https://i.ytimg.com/vi/jKquo4mjBR4/sddefault.jpg',
             'keywords': [],
             'length': 2308,
             'title': 'R̲ob Z̲ombie - H̲ellbilly D̲eluxe (Full Album)',
             'url': 'https://youtube.com/watch?v=jKquo4mjBR4',
             'videoId': 'jKquo4mjBR4'},
            {'author': 'WhiteZombieVEVO',
             'image': 'https://i.ytimg.com/vi/yPNFVj-pISU/sddefault.jpg',
             'keywords': ['White',
                          'Zombie',
                          'GEFFEN',
                          'Rock',
                          'white zombie thunder kiss 65',
                          'white zombie vevo'],
             'length': 237,
             'title': "White Zombie - Thunder Kiss '65 (Official Video)",
             'url': 'https://youtube.com/watch?v=yPNFVj-pISU',
             'videoId': 'yPNFVj-pISU'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/VK16w_Esrno/sddefault.jpg',
             'keywords': ['Rob', 'Zombie', 'GEFFEN', 'Metal'],
             'length': 218,
             'title': 'Rob Zombie - Feel So Numb',
             'url': 'https://youtube.com/watch?v=VK16w_Esrno',
             'videoId': 'VK16w_Esrno'},
            {'author': 'Rob Zombie - Topic',
             'image': 'https://i.ytimg.com/vi/SOctyXxCm-4/sddefault.jpg',
             'keywords': ['Rob Zombie',
                          'ロブゾンビ',
                          'ロブ・ゾンビ',
                          'Hellbilly Deluxe',
                          'Dragula',
                          'ドラギュラ'],
             'length': 223,
             'title': 'Dragula',
             'url': 'https://youtube.com/watch?v=SOctyXxCm-4',
             'videoId': 'SOctyXxCm-4'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/uHBtpqbOKXk/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Geffen',
                          'Rock',
                          'Rob Zombie Superbeast',
                          'Rob Zombie Vevo'],
             'length': 221,
             'title': 'Rob Zombie - Superbeast (Official Video)',
             'url': 'https://youtube.com/watch?v=uHBtpqbOKXk',
             'videoId': 'uHBtpqbOKXk'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/0698sTH7mUk/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'GEFFEN',
                          'Metal',
                          'rob zombie never gonna stop',
                          'rob zombie vevo'],
             'length': 192,
             'title': 'Rob Zombie - Never Gonna Stop (The Red Red Kroovy) '
                      '[Official Video]',
             'url': 'https://youtube.com/watch?v=0698sTH7mUk',
             'videoId': '0698sTH7mUk'},
            {'author': 'WhiteZombieVEVO',
             'image': 'https://i.ytimg.com/vi/E0E0ynyIUsg/sddefault.jpg',
             'keywords': ['White',
                          'Zombie',
                          'Geffen',
                          'Pop',
                          'White Zombie More Human Than Human',
                          'White Zombie More Human Than Human Vevo',
                          'White Zombie Vevo',
                          'Vevo'],
             'length': 256,
             'title': 'White Zombie - More Human Than Human (Official Video)',
             'url': 'https://youtube.com/watch?v=E0E0ynyIUsg',
             'videoId': 'E0E0ynyIUsg'},
            {'author': 'Nuclear Blast Records',
             'image': 'https://i.ytimg.com/vi/awvd0AGpvuE/sddefault.jpg',
             'keywords': ['Rob Zombie',
                          'John 5',
                          'Piggy D',
                          'Ginger Fish',
                          'Rob Zombie King Freak',
                          'Rob Zombie Lunar Injection',
                          'The Lunar Injection Kool Aid Eclipse Conspiracy',
                          'The Triumph of King Freak (A Crypt of Preservation '
                          'and Superstition)',
                          'Rob Zombie Full Album',
                          'Rob Zombie Music Video',
                          'Rob Zombie Official Video',
                          'Rob Zombie Official Music Video',
                          'Rob Zombie Dragula',
                          'Rob Zombie Living Dead Girl',
                          'Rob Zombie Superbeast',
                          'Industrial Metal',
                          'Shock Rock',
                          'Rob Zombie Howling Man',
                          'Rob Zombie New Album 2021'],
             'length': 269,
             'title': 'ROB ZOMBIE - Crow Killer Blues (OFFICIAL MUSIC VIDEO)',
             'url': 'https://youtube.com/watch?v=awvd0AGpvuE',
             'videoId': 'awvd0AGpvuE'},
            {'author': 'Roadrunner Records',
             'image': 'https://i.ytimg.com/vi/AeUwikDrA9I/hqdefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Sick',
                          'Bubblegum',
                          'Rock',
                          'Hard',
                          'metal',
                          'music',
                          'video',
                          'roadrunner',
                          'records',
                          'explicit',
                          'joey',
                          'jordison',
                          'hellbilly',
                          'deluxe'],
             'length': 221,
             'title': 'Rob Zombie - Sick Bubblegum',
             'url': 'https://youtube.com/watch?v=AeUwikDrA9I',
             'videoId': 'AeUwikDrA9I'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/kgltKEKw_wA/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Ging',
                          'Gang',
                          'Gong',
                          'De',
                          'Do',
                          'Laga',
                          'Raga',
                          'Concert',
                          'Album/Film',
                          '(PS)',
                          'Rock'],
             'length': 251,
             'title': 'Rob Zombie - Ging Gang Gong De Do Gong De Laga Raga '
                      '(Audio / Live)',
             'url': 'https://youtube.com/watch?v=kgltKEKw_wA',
             'videoId': 'kgltKEKw_wA'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/csUf0MAUIs4/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Well',
                          'Everybody’s',
                          'Fucking',
                          'in',
                          'U.F.O.',
                          'UMe',
                          'Rock'],
             'length': 409,
             'title': 'Rob Zombie - Well, Everybody’s Fucking in a U.F.O. '
                      '(Explicit)',
             'url': 'https://youtube.com/watch?v=csUf0MAUIs4',
             'videoId': 'csUf0MAUIs4'},
            {'author': 'The Pure Music Factory',
             'image': 'https://i.ytimg.com/vi/jP4r4qei9cQ/sddefault.jpg',
             'keywords': [],
             'length': 210,
             'title': 'Rob Zombie - BOOM-BOOM-BOOM (Music Video)',
             'url': 'https://youtube.com/watch?v=jP4r4qei9cQ',
             'videoId': 'jP4r4qei9cQ'},
            {'author': 'Nuclear Blast Records',
             'image': 'https://i.ytimg.com/vi/0WULTU6zl2E/sddefault.jpg',
             'keywords': ['Rob Zombie',
                          'John 5',
                          'Piggy D',
                          'Ginger Fish',
                          'Rob Zombie King Freak',
                          'Rob Zombie Lunar Injection',
                          'The Lunar Injection Kool Aid Eclipse Conspiracy',
                          'The Triumph of King Freak (A Crypt of Preservation '
                          'and Superstition)',
                          'Rob Zombie New Album 2020',
                          'Rob Zombie Full Album',
                          'Rob Zombie Music Video',
                          'Rob Zombie Official Video',
                          'Rob Zombie Official Music Video',
                          'Rob Zombie Dragula',
                          'Rob Zombie Living Dead Girl',
                          'Rob Zombie Superbeast',
                          'Industrial Metal',
                          'Shock Rock',
                          'Robo Zombie New Track 2020'],
             'length': 253,
             'title': 'ROB ZOMBIE - The Triumph of King Freak (A Crypt of '
                      'Preservation and Superstition) (MUSIC VIDEO)',
             'url': 'https://youtube.com/watch?v=0WULTU6zl2E',
             'videoId': '0WULTU6zl2E'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/Wzlky9Klu4I/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          "We're",
                          'An',
                          'American',
                          'Band',
                          'UME',
                          'Rock'],
             'length': 216,
             'title': "Rob Zombie - We're An American Band",
             'url': 'https://youtube.com/watch?v=Wzlky9Klu4I',
             'videoId': 'Wzlky9Klu4I'},
            {'author': 'The Pit',
             'image': 'https://i.ytimg.com/vi/0viDab5XSRg/sddefault.jpg',
             'keywords': ['rob zombie',
                          'sick bubblegum',
                          'rob zombie sick bubblegum',
                          'sick bubblegum rob zombie',
                          'sick bubblegum video',
                          'rob zombie sick bubblegum video',
                          'sick bubblegum rob zombie video',
                          'rob zombie music video',
                          'hellbilly deluxe 2 rob zombie',
                          'hellbilly deluxe 2 videos',
                          'sick bubblegum music videos',
                          'official music video',
                          'the pit',
                          'metal',
                          'heavy metal videos',
                          'metal music'],
             'length': 226,
             'title': 'Rob Zombie - Sick Bubblegum (Official Music Video)',
             'url': 'https://youtube.com/watch?v=0viDab5XSRg',
             'videoId': '0viDab5XSRg'},
            {'author': 'Nuclear Blast Records',
             'image': 'https://i.ytimg.com/vi/SzsAsoF_Aqs/sddefault.jpg',
             'keywords': ['Rob Zombie',
                          'John 5',
                          'Piggy D',
                          'Ginger Fish',
                          'Rob Zombie King Freak',
                          'Rob Zombie Lunar Injection',
                          'The Lunar Injection Kool Aid Eclipse Conspiracy',
                          'The Triumph of King Freak (A Crypt of Preservation '
                          'and Superstition)',
                          'Rob Zombie Full Album',
                          'Rob Zombie Music Video',
                          'Rob Zombie Official Video',
                          'Rob Zombie Official Music Video',
                          'Rob Zombie Dragula',
                          'Rob Zombie Living Dead Girl',
                          'Rob Zombie Superbeast',
                          'Industrial Metal',
                          'Shock Rock',
                          'Rob Zombie New Album 2021',
                          'Rob Zombie Crow Killer Blues'],
             'length': 195,
             'title': 'ROB ZOMBIE - Shadow Of The Cemetery Man (OFFICIAL MUSIC '
                      'VIDEO)',
             'url': 'https://youtube.com/watch?v=SzsAsoF_Aqs',
             'videoId': 'SzsAsoF_Aqs'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/AzJEpch-i6A/sddefault.jpg',
             'keywords': ['Rob', 'Zombie', 'Geffen', 'Rock'],
             'length': 243,
             'title': 'Rob Zombie - Demonoid Phenomenon',
             'url': 'https://youtube.com/watch?v=AzJEpch-i6A',
             'videoId': 'AzJEpch-i6A'},
            {'author': 'Rob Zombie - Topic',
             'image': 'https://i.ytimg.com/vi/xKSOqLPp16I/sddefault.jpg',
             'keywords': ['Rob Zombie',
                          'ロブゾンビ',
                          'ロブ・ゾンビ',
                          'The Sinister Urge',
                          'Demon Speeding',
                          'デーモンズ・スピ－ディング'],
             'length': 224,
             'title': 'Demon Speeding',
             'url': 'https://youtube.com/watch?v=xKSOqLPp16I',
             'videoId': 'xKSOqLPp16I'},
            {'author': 'PowerfulJRE',
             'image': 'https://i.ytimg.com/vi/KDLeJ5Rasuo/sddefault.jpg',
             'keywords': ['Joe Rogan Experience',
                          'JRE',
                          'Joe',
                          'Rogan',
                          'podcast',
                          'MMA',
                          'comedy',
                          'stand',
                          'up',
                          'funny',
                          'Freak',
                          'Party',
                          'Rob Zombie',
                          'Joe Rogan',
                          '3 From Hell',
                          'JRE #1353'],
             'length': 7561,
             'title': 'Joe Rogan Experience #1353 - Rob Zombie',
             'url': 'https://youtube.com/watch?v=KDLeJ5Rasuo',
             'videoId': 'KDLeJ5Rasuo'},
            {'author': 'Tim Sipkes',
             'image': 'https://i.ytimg.com/vi/BwK4wItwgTc/hqdefault.jpg',
             'keywords': ['Rob', 'Zombie', 'Dragula', 'Ozzfest', '2005'],
             'length': 328,
             'title': 'Rob Zombie - Dragula (Live @ Ozzfest 2005)',
             'url': 'https://youtube.com/watch?v=BwK4wItwgTc',
             'videoId': 'BwK4wItwgTc'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/bXvTk-N0HKo/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'The',
                          'Life',
                          'And',
                          'Times',
                          'Of',
                          'Teenage',
                          'Rock',
                          'God',
                          '(PS)'],
             'length': 312,
             'title': 'Rob Zombie - The Life And Times Of A Teenage Rock God',
             'url': 'https://youtube.com/watch?v=bXvTk-N0HKo',
             'videoId': 'bXvTk-N0HKo'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/2H33bQZx4Ig/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Demonoid',
                          'Phenomenon',
                          'GEFFEN',
                          'Rock'],
             'length': 243,
             'title': 'Rob Zombie - Demonoid Phenomenon (Explicit)',
             'url': 'https://youtube.com/watch?v=2H33bQZx4Ig',
             'videoId': '2H33bQZx4Ig'},
            {'author': 'Rob Zombie - Topic',
             'image': 'https://i.ytimg.com/vi/NhrCkKX1-1I/sddefault.jpg',
             'keywords': ['Rob Zombie',
                          'ロブゾンビ',
                          'ロブ・ゾンビ',
                          'House Of 1000 Corpses',
                          'Pussy Liquor',
                          'プッシー・リカー'],
             'length': 298,
             'title': 'Pussy Liquor (From "House Of 1000 Corpses" Soundtrack)',
             'url': 'https://youtube.com/watch?v=NhrCkKX1-1I',
             'videoId': 'NhrCkKX1-1I'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/FVN6CDo02gA/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'In',
                          'The',
                          'Age',
                          'Of',
                          'Consecrated',
                          'Vampire',
                          'We',
                          'All',
                          'Get',
                          'High',
                          '(PS)',
                          'Rock'],
             'length': 138,
             'title': 'Rob Zombie - Get High',
             'url': 'https://youtube.com/watch?v=FVN6CDo02gA',
             'videoId': 'FVN6CDo02gA'},
            {'author': 'The Pure Music Factory',
             'image': 'https://i.ytimg.com/vi/8B35ciUTONQ/sddefault.jpg',
             'keywords': [],
             'length': 196,
             'title': 'Rob Zombie - Shake Your Ass-Smoke Your Grass [Music '
                      'Video]',
             'url': 'https://youtube.com/watch?v=8B35ciUTONQ',
             'videoId': '8B35ciUTONQ'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/QcKxMoJB4L0/sddefault.jpg',
             'keywords': ['Rob', 'Zombie', 'GEFFEN', 'Rock'],
             'length': 270,
             'title': 'Rob Zombie - Return Of The Phantom Stranger',
             'url': 'https://youtube.com/watch?v=QcKxMoJB4L0',
             'videoId': 'QcKxMoJB4L0'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/LmXdpv3pCGU/sddefault.jpg',
             'keywords': ['Rob', 'Zombie', 'Geffen', 'Rock'],
             'length': 216,
             'title': 'Rob Zombie - Foxy, Foxy',
             'url': 'https://youtube.com/watch?v=LmXdpv3pCGU',
             'videoId': 'LmXdpv3pCGU'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/MdKXShP_oc4/sddefault.jpg',
             'keywords': ['Rob', 'Zombie', 'Geffen', 'Rock'],
             'length': 208,
             'title': 'Rob Zombie - American Witch',
             'url': 'https://youtube.com/watch?v=MdKXShP_oc4',
             'videoId': 'MdKXShP_oc4'},
            {'author': 'azzajack',
             'image': 'https://i.ytimg.com/vi/Z0dA3h05EBQ/hqdefault.jpg',
             'keywords': ['metal',
                          'rob',
                          'zombie',
                          'dragula',
                          'mriganka',
                          'ghosh',
                          'jack',
                          'lyrics',
                          'azzajack',
                          'white',
                          'hard',
                          'rock',
                          'music',
                          'scary',
                          'hellbilly',
                          'deluxe',
                          'sled',
                          'storm'],
             'length': 228,
             'title': 'Rob Zombie - Dragula Lyrics Video',
             'url': 'https://youtube.com/watch?v=Z0dA3h05EBQ',
             'videoId': 'Z0dA3h05EBQ'},
            {'author': 'RobZombieVEVO',
             'image': 'https://i.ytimg.com/vi/3XAJ4eijs7Y/sddefault.jpg',
             'keywords': ['Rob',
                          'Zombie',
                          'Medication',
                          'For',
                          'The',
                          'Melancholy',
                          '(PS)',
                          'Rock'],
             'length': 147,
             'title': 'Rob Zombie - Medication For The Melancholy',
             'url': 'https://youtube.com/watch?v=3XAJ4eijs7Y',
             'videoId': '3XAJ4eijs7Y'},
            {'author': 'HorrorSoundtrack',
             'image': 'https://i.ytimg.com/vi/RDMmzCK6vjA/sddefault.jpg',
             'keywords': ['Rob Zombie',
                          'House of 1000 Corpses',
                          'Pussy Liquor',
                          'Soundtrack'],
             'length': 298,
             'title': 'Rob Zombie - Pussy Liquor (Soundtrack)',
             'url': 'https://youtube.com/watch?v=RDMmzCK6vjA',
             'videoId': 'RDMmzCK6vjA'},
            {'author': 'White Zombie - Topic',
             'image': 'https://i.ytimg.com/vi/OyO18QrJ3zw/sddefault.jpg',
             'keywords': ['White Zombie ホワイトゾンビ ホワイト・ゾンビ Past',
                          'Present & Future More Human Than Human '
                          'モア・ヒューマン・ザン・ヒューマン'],
             'length': 270,
             'title': 'More Human Than Human',
             'url': 'https://youtube.com/watch?v=OyO18QrJ3zw',
             'videoId': 'OyO18QrJ3zw'},
            {'author': 'Rock Feed',
             'image': 'https://i.ytimg.com/vi/lH_rjioUlIw/sddefault.jpg?v=5e5961d7',
             'keywords': ['rob zombie',
                          '3 from hell',
                          'three from hell',
                          'rob zombie living dead girl',
                          'rob zombie superbeast',
                          'rob zombie never gonna stop',
                          'rob zombie dragula lyrics',
                          'rob zombie more human than human',
                          'rob zombie thunder kiss 65',
                          'rob zombie house of 1000 corpses',
                          'rob zombie live',
                          'rob zombie feel so numb',
                          'rob zombie never gonna stpo',
                          'rob zombie moreso human than human',
                          'rob zombie more so human than human',
                          'rob zombie fiel so numb',
                          'rob zombie phial so numb'],
             'length': 686,
             'title': 'The Mysterious Life Of Rob Zombie',
             'url': 'https://youtube.com/watch?v=lH_rjioUlIw',
             'videoId': 'lH_rjioUlIw'}]}
"""
```