import { IScheduleTarget, ISchedule } from '@aws-cdk/aws-scheduler-alpha';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { IStateMachine } from 'aws-cdk-lib/aws-stepfunctions';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Use an AWS Step function as a target for AWS EventBridge Scheduler.
 */
export declare class StepFunctionsStartExecution extends ScheduleTargetBase implements IScheduleTarget {
    private readonly stateMachine;
    private readonly props;
    constructor(stateMachine: IStateMachine, props: ScheduleTargetBaseProps);
    protected addTargetActionToRole(schedule: ISchedule, role: IRole): void;
}
