import { ISchedule, IScheduleTarget, ScheduleTargetConfig } from '@aws-cdk/aws-scheduler-alpha';
import { IRole } from 'aws-cdk-lib/aws-iam';
import * as sqs from 'aws-cdk-lib/aws-sqs';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Properties for a SQS Queue Target
 */
export interface SqsSendMessageProps extends ScheduleTargetBaseProps {
    /**
     * The FIFO message group ID to use as the target.
     *
     * This must be specified when the target is a FIFO queue. If you specify
     * a FIFO queue as a target, the queue must have content-based deduplication enabled.
     *
     * A length of `messageGroupId` must be between 1 and 128.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-scheduler-schedule-sqsparameters.html#cfn-scheduler-schedule-sqsparameters-messagegroupid
     *
     * @default - no message group ID
     */
    readonly messageGroupId?: string;
}
/**
 * Use an Amazon SQS Queue as a target for AWS EventBridge Scheduler.
 */
export declare class SqsSendMessage extends ScheduleTargetBase implements IScheduleTarget {
    private readonly queue;
    private readonly props;
    constructor(queue: sqs.IQueue, props: SqsSendMessageProps);
    protected addTargetActionToRole(schedule: ISchedule, role: IRole): void;
    protected bindBaseTargetConfig(_schedule: ISchedule): ScheduleTargetConfig;
}
