import { ISchedule, IScheduleTarget } from '@aws-cdk/aws-scheduler-alpha';
import { IRole } from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Use an AWS Lambda function as a target for AWS EventBridge Scheduler.
 */
export declare class LambdaInvoke extends ScheduleTargetBase implements IScheduleTarget {
    private readonly func;
    private readonly props;
    constructor(func: lambda.IFunction, props: ScheduleTargetBaseProps);
    protected addTargetActionToRole(schedule: ISchedule, role: IRole): void;
}
