"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InspectorStartAssessmentRun = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const target_1 = require("./target");
const util_1 = require("./util");
/**
 * Use an Amazon Inspector as a target for AWS EventBridge Scheduler.
 */
class InspectorStartAssessmentRun extends target_1.ScheduleTargetBase {
    constructor(template, props = {}) {
        super(props, template.attrArn);
        this.template = template;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, InspectorStartAssessmentRun);
            }
            throw error;
        }
    }
    addTargetActionToRole(schedule, role) {
        if (!(0, util_1.sameEnvDimension)(this.template.stack.region, schedule.env.region)) {
            throw new Error(`Cannot assign assessment template in region ${this.template.stack.region} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in region ${schedule.env.region}. Both the schedule and the assessment template must be in the same region.`);
        }
        if (!(0, util_1.sameEnvDimension)(this.template.stack.account, schedule.env.account)) {
            throw new Error(`Cannot assign assessment template in account ${this.template.stack.account} to the schedule ${aws_cdk_lib_1.Names.nodeUniqueId(schedule.node)} in account ${schedule.env.region}. Both the schedule and the assessment template must be in the same account.`);
        }
        if (this.props.role && !(0, util_1.sameEnvDimension)(this.props.role.env.account, this.template.stack.account)) {
            throw new Error(`Cannot grant permission to execution role in account ${this.props.role.env.account} to invoke target ${aws_cdk_lib_1.Names.nodeUniqueId(this.template.node)} in account ${this.template.stack.account}. Both the target and the execution role must be in the same account.`);
        }
        role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            actions: ['inspector:StartAssessmentRun'],
            resources: ['*'],
        }));
    }
}
exports.InspectorStartAssessmentRun = InspectorStartAssessmentRun;
_a = JSII_RTTI_SYMBOL_1;
InspectorStartAssessmentRun[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.InspectorStartAssessmentRun", version: "2.145.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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