import { ISchedule, IScheduleTarget } from '@aws-cdk/aws-scheduler-alpha';
import { IProject } from 'aws-cdk-lib/aws-codebuild';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Use an AWS CodeBuild as a target for AWS EventBridge Scheduler.
 */
export declare class CodeBuildStartBuild extends ScheduleTargetBase implements IScheduleTarget {
    private readonly project;
    private readonly props;
    constructor(project: IProject, props?: ScheduleTargetBaseProps);
    protected addTargetActionToRole(schedule: ISchedule, role: IRole): void;
}
