# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['basecampapi', 'basecampapi.endpoints']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.28.1,<3.0.0']

setup_kwargs = {
    'name': 'basecampapi',
    'version': '0.2.1',
    'description': '',
    'long_description': '\n\n\n# Basecamp API\n\nThis package allows simple interaction with [Basecamp API](https://github.com/basecamp/bc3-api) using Python.\n\n## Table of contents\n\n1. [Installation](https://github.com/mare011rs/basecampapi#1-installation)\n2. [Initial authentication: Getting your refresh token](https://github.com/mare011rs/basecampapi#2-initial-authentication-getting-your-refresh-token)\n3. [Generating and using Basecamp sessions](https://github.com/mare011rs/basecampapi#3-generating-and-using-basecamp-sessions)\n4. [Uploading files](https://github.com/mare011rs/basecampapi#4-uploading-files)\n5. [Additional information](https://github.com/mare011rs/basecampapi#5-additional-information)\n\n## 1. Installation\nThe package can be installed from your terminal by typing:\n\n    pip install basecampapi\nor\n\n    pip3 install basecampapi\n\n\n## 2. Initial authentication: Getting your refresh token\n\nTo be able to interact with Basecamp\'s API, we need to provide an access token upon each API request. Basecamp\'s access tokens are set to expire 2 weeks after being generated, which is why we need to generate a refresh token.\n\nRefresh token allows us to automate the process of generating an access token. We only have to generate the refresh token once and after that we can use it to gain access to Basecamp each time we run our script.\n\nTo gain access you need a developer app on Basecamp. App can be created on https://launchpad.37signals.com/integrations, after which you need to use the generated Client ID, Client Secret and the Redirect URI which you provided for initial authentication. You can read more about the authentication process on [Basecamp API Authentication](https://github.com/basecamp/api/blob/master/sections/authentication.md) page.\n\nTo begin the authentication process, you need to create a dictionary with your app credentials and use it in the `Authorization` object:\n\n```python\nimport basecampapi as bc\n\ncredentials = {\n\tclient_id: "your-client-id",\n\tclient_secret: "your-client-secret",\n\tredirect_uri: "your-redirect-uri"\n}\n\nauth = bc.Authorization(credentials=credentials)\n```\n\nThis will open a verification page in your browser. Click on "Yes, I\'ll allow access":\n\n![Verification page](https://user-images.githubusercontent.com/24939829/209202366-bae05d01-5f8d-4ca6-a0f8-5e1eb9088acd.png  "Verification page")\n\nIt will redirect you to the link you provided as Redirect URI, but it will have the verification code in the url address. Save that verification code:\n\n![Verification code](https://user-images.githubusercontent.com/24939829/209202400-d2aa342b-70e1-4fd1-9787-2f3dc1280a57.png  "Verification code")\n\nUse the the `verify()` method on the previously created `Authorization` object and add your verification code to generate the refresh token:\n\n```python\n# Verification code variable \nmy_verification_code = "17beb4cd"\n\nauth.verify(code=my_verification_code)\n```\n\n`verify()` method will print out your refresh token. Make sure to save it and don\'t share it with anyone because it allows access to your personal Basecamp account and anyone with this information would be able to impersonate you on Basecamp. You will use this refresh token each time you access the Basecamp API, so make sure you save it somewhere safe.\n\n\n\n\n## 3. Generating and using Basecamp sessions\nTo interact with objects on Basecamp you have to initialize a session object. This object will generate your access token and allow you to interact with other Basecamp objects. To do this, you need to pass your credentials and account ID to the `Basecamp` object.\n\nYour account ID can be found on your Basecamp home page, in the URL address:\n- https:<SPAN></SPAN>//3.basecamp.com/<b>YOUR-ACCOUNT-ID</b>/projects\n\n```python\nimport basecampapi as bc\n\ncredentials = {\n\t"client_id": "your-client-id",\n\t"client_secret": "your-client-secret",\n\t"redirect_uri": "your-redirect-uri",\n\t"refresh_token": "your-refresh-token"\n}\n\nbasecamp_session = bc.Basecamp(account_id="your-account-id", credentials=credentials)\n```\nAfter that you will be able to use your session object within other Basecamp objects.\n\n```python\n# Initiates a Campfire object using previously created session\nmy_campfire = bc.Campfire(campfire_id=\'your-campfire-id\', project_id=\'your-project-id\', session=basecamp_session)\n# Sends a campfire message with desired content\nmy_campfire.write(content="Hello from Python!") \n```\n\n\n## 4. Uploading files\n\nWhen attaching images or other files to Basecamp posts we do this by using [Rich text](https://github.com/basecamp/bc3-api/blob/3f71ee57b278be6e71f51488c71197f600395a2b/sections/rich_text.md), which means that we will be sending HTML as content to the Basecamp object we want to interact with. \n\nSending rich text through API is not allowed on all Basecamp objects that have rich text by themselves. Best example are Campfires, when interacting with Basecamp you can upload images and files to a campfire or edit the text style, but Basecamp API does not allow this to be done programatically. Here is a [list](https://github.com/basecamp/bc3-api/blob/3f71ee57b278be6e71f51488c71197f600395a2b/sections/rich_text.md#rich-text-content-attributes) of Basecamp endpoints that can accept rich text.\n\n\nTo upload a file to Basecamp, first we need upload the file to Basecamp\'s server and get its `attachable_sgid`. We can do this by passing the file path to the `upload_file()` method on our `Basecamp` session object:\n\n```python\nbasecamp_session.upload_file("folder/image.png")\n```\nAfter this the file will be on Basecamp\'s server and it will have an automatically generated `attachable_sgid` Uploaded files can be accessed through session:\n```python\nprint(basecamp_session.files)\n```\nThis returns a list of dictionaries that contain information about the files you uploaded:\n```python\n[{\'filename\': \'image.png\',\n  \'file_size\': \'155291\',\n  \'content-type\': \'image/png\',\n  \'sgid\': \'your-file-sgid\'}]\n```\nTo attach a file inside a Basecamp post, comment or any other object where rich text is accessible through API, we need to send an HTML string  as the content parameter of the object we are interacting with, and we need to use the `<bc-attachment>` tag for any file attachments.\n\n```python\n"<bc-attachment sgid=\'your-file-sgid\'></bc-attachment>"\n```\n\nCreating a new Message Board post on Basecamp with our uploaded image will look like this:\n```python\n# Constructing the content string\ncontent = "Hello world! <br> / \n<bc-attachment sgid=\'#######\'></bc-attachment> <br> /\nThis is an image sent from python."\n\n# Initiating the message board object (using the previously created session object)\nmessage_board = MessageBoard(project_id=123456, message_board_id=123456, session=basecamp_session)\n\n# Creating a message\nmessage_board.create_message(subject="Test message", content=content)\n```\n\n## 5. Additional information\n\nCurrently available endpoints:\n- Campfire - allows reading campfire messages and writing to campfires\n- MessageBoard - allows reading, creating and updating messages, as well as reading, creating and updating comments on messages\n\nFuture upgrades:\n- Vaults (Docs & Files)\n- To-dos\n\n',
    'author': 'mare011rs',
    'author_email': 'mare011rs@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
