ML4Chem
===========
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/Django.svg)](https://github.com/muammar/mkchromecast/)
[![Build Status](https://travis-ci.com/muammar/ml4chem.svg?branch=master)](https://travis-ci.com/muammar/ml4chem)
[![License](https://img.shields.io/badge/license-BSD-green)](https://github.com/muammar/ml4chem/blob/master/LICENSE)
[![Downloads](https://img.shields.io/github/downloads/muammar/ml4chem/total.svg?maxAge=2592000?style=flat-square)](https://github.com/muammar/ml4chem/releases)
[![GitHub release](https://img.shields.io/github/release/ml4chem/ml4chem.svg)](https://github.com/muammar/ml4chem/releases/latest)

**ML4Chem** is machine learning for chemistry and Materials.

This package is written in Python 3, and intends to offer modern and rich
features to perform machine learning workflows for chemical physics.

A list of features and methods are shown below.

- Atom-centered Neural Networks, and Kernel Ridge Regression for the prediction
  of total energies.
- PyTorch backend.
- GPU support.
- ASE interface.
- Completely modular. You can use any part of this package in your project.
- Free software <3. No secrets! Pull requests and additions are more than
  welcome!
- Good documentation (I hope!).
- Explicit and idiomatic: `ml4chem.get_me_a_coffee()`.
- Distributed training in a data parallelism paradigm (mini-batches).
- Scalability and distributed computations are powered by Dask <3.
- Real-time tools to track status of your computations.
- [Messagepack serialization](https://msgpack.org/index.html).


## Dask dashboard
![](https://raw.githubusercontent.com/muammar/ml4chem/master/docs/source/_static/dask_dashboard.png)

Note: This package is under development.

## Copyright
ML4Chem: Machine Learning for Chemistry and Materials (ML4Chem) Copyright (c) 2019, The
Regents of the University of California, through Lawrence Berkeley National
Laboratory (subject to receipt of any required approvals from the U.S.
Dept. of Energy).  All rights reserved.

If you have questions about your rights to use or distribute this software,
please contact Berkeley Lab's Intellectual Property Office at
IPO@lbl.gov.

NOTICE.  This Software was developed under funding from the U.S. Department
of Energy and the U.S. Government consequently retains certain rights.  As
such, the U.S. Government has been granted for itself and others acting on
its behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
Software to reproduce, distribute copies to the public, prepare derivative
works, and perform publicly and display publicly, and to permit other to do
so.
