# streamduo
Swagger docs for streamduo.com

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [www.streamduo.com](www.streamduo.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import streamduo 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import streamduo
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import streamduo
from streamduo.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = streamduo.ClientControllerApi(streamduo.ApiClient(configuration))
id = 'id_example' # str | id

try:
    # deleteClient
    api_response = api_instance.delete_machine_client(id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ClientControllerApi->delete_machine_client: %s\n" % e)

# create an instance of the API class
api_instance = streamduo.ClientControllerApi(streamduo.ApiClient(configuration))
id = 'id_example' # str | id

try:
    # getClientDetails
    api_response = api_instance.get_machine_client(id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ClientControllerApi->get_machine_client: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *//localhost:8081/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ClientControllerApi* | [**delete_machine_client**](docs/ClientControllerApi.md#delete_machine_client) | **DELETE** /client/{id} | deleteClient
*ClientControllerApi* | [**get_machine_client**](docs/ClientControllerApi.md#get_machine_client) | **GET** /client/{id} | getClientDetails
*HealthControllerApi* | [**health_using_get**](docs/HealthControllerApi.md#health_using_get) | **GET** /health | health
*OrganizationControllerApi* | [**add_user_to_organization**](docs/OrganizationControllerApi.md#add_user_to_organization) | **POST** /organization/{id}/update | addUser
*OrganizationControllerApi* | [**create_organization**](docs/OrganizationControllerApi.md#create_organization) | **POST** /organization | createOrganization
*OrganizationControllerApi* | [**delete_organization**](docs/OrganizationControllerApi.md#delete_organization) | **DELETE** /organization/{id} | deleteOrganization
*OrganizationControllerApi* | [**get_organization**](docs/OrganizationControllerApi.md#get_organization) | **GET** /organization/{id} | getOrganization
*RecordControllerApi* | [**read_record_request**](docs/RecordControllerApi.md#read_record_request) | **POST** /stream/{streamId}/record-request | getrecords
*RecordControllerApi* | [**write_record**](docs/RecordControllerApi.md#write_record) | **POST** /stream/{streamId}/record/ | writeRecord
*StreamControllerApi* | [**add_machine_client_to_stream**](docs/StreamControllerApi.md#add_machine_client_to_stream) | **POST** /stream/{id}/add/client/new | addNewClient
*StreamControllerApi* | [**create_stream**](docs/StreamControllerApi.md#create_stream) | **POST** /stream | createStream
*StreamControllerApi* | [**delete_stream**](docs/StreamControllerApi.md#delete_stream) | **DELETE** /stream/{id} | deleteStream
*StreamControllerApi* | [**get_stream**](docs/StreamControllerApi.md#get_stream) | **GET** /stream/{id} | getStream
*UserControllerApi* | [**create_user**](docs/UserControllerApi.md#create_user) | **POST** /user | createUser
*UserControllerApi* | [**get_user**](docs/UserControllerApi.md#get_user) | **GET** /user | getUser

## Documentation For Models

 - [Client](docs/Client.md)
 - [Organization](docs/Organization.md)
 - [OrganizationAlterUserRequest](docs/OrganizationAlterUserRequest.md)
 - [ReadRecordRequest](docs/ReadRecordRequest.md)
 - [Record](docs/Record.md)
 - [Stream](docs/Stream.md)
 - [StreamActorPermissionRecord](docs/StreamActorPermissionRecord.md)
 - [StreamAffiliationRecord](docs/StreamAffiliationRecord.md)
 - [User](docs/User.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author

steve@streamduo.com
