"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    time_range_type: str = None,
    sampling: bool = None,
    sampling_strategy: Dict = None,
    filter_expression: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get the full traces, pass the trace IDs to BatchGetTraces. A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come from a known user. For example, the following filter expression targets traces that pass through api.example.com:  service("api.example.com")  This filter expression finds traces that have an annotation named account with the value 12345:  annotation.account = "12345"  For a full list of indexed fields and keywords that you can use in filter expressions, see Using Filter Expressions in the AWS X-Ray Developer Guide.

    Args:
        start_time(str): The start of the time frame for which to retrieve traces.
        end_time(str): The end of the time frame for which to retrieve traces.
        time_range_type(str, optional): A parameter to indicate whether to query trace summaries by TraceId or Event time. Defaults to None.
        sampling(bool, optional): Set to true to get summaries for only a subset of available traces. Defaults to None.
        sampling_strategy(Dict, optional): A parameter to indicate whether to enable sampling on trace summaries. Input parameters are Name and Value. Defaults to None.
        filter_expression(str, optional): Specify a filter expression to retrieve trace summaries for services or requests that meet certain requirements. Defaults to None.
        next_token(str, optional): Specify the pagination token returned by a previous request to retrieve the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.trace.summary.get_all(
                ctx, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.trace.summary.get_all start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_trace_summaries",
        op_kwargs={
            "StartTime": start_time,
            "EndTime": end_time,
            "TimeRangeType": time_range_type,
            "Sampling": sampling,
            "SamplingStrategy": sampling_strategy,
            "FilterExpression": filter_expression,
            "NextToken": next_token,
        },
    )
