"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, trace_ids: List, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a service graph for one or more specific trace IDs.

    Args:
        trace_ids(List): Trace IDs of requests for which to generate a service graph.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.trace.graph.get(ctx, trace_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.trace.graph.get trace_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_trace_graph",
        op_kwargs={"TraceIds": trace_ids, "NextToken": next_token},
    )
