"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    group_name: str = None,
    group_arn: str = None,
    entity_selector_expression: str = None,
    period: int = None,
    forecast_statistics: bool = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Get an aggregation of service statistics defined by a specific time range.

    Args:
        start_time(str): The start of the time frame for which to aggregate statistics.
        end_time(str): The end of the time frame for which to aggregate statistics.
        group_name(str, optional): The case-sensitive name of the group for which to pull statistics from. Defaults to None.
        group_arn(str, optional): The Amazon Resource Name (ARN) of the group for which to pull statistics from. Defaults to None.
        entity_selector_expression(str, optional): A filter expression defining entities that will be aggregated for statistics. Supports ID, service, and edge functions. If no selector expression is specified, edge statistics are returned. . Defaults to None.
        period(int, optional): Aggregation period in seconds. Defaults to None.
        forecast_statistics(bool, optional): The forecasted high and low fault count values. Forecast enabled requests require the EntitySelectorExpression ID be provided. Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.time_series_service_statistic.get_all(
                ctx, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.time_series_service_statistic.get_all start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_time_series_service_statistics",
        op_kwargs={
            "StartTime": start_time,
            "EndTime": end_time,
            "GroupName": group_name,
            "GroupARN": group_arn,
            "EntitySelectorExpression": entity_selector_expression,
            "Period": period,
            "ForecastStatistics": forecast_statistics,
            "NextToken": next_token,
        },
    )
