"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(
    hub,
    ctx,
    telemetry_records: List,
    ec2_instance_id: str = None,
    hostname: str = None,
    resource_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used by the AWS X-Ray daemon to upload telemetry.

    Args:
        telemetry_records(List): .
        ec2_instance_id(str, optional): . Defaults to None.
        hostname(str, optional): . Defaults to None.
        resource_arn(str, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.telemetry_record.put_multiple(ctx, telemetry_records=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.telemetry_record.put_multiple telemetry_records=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="put_telemetry_records",
        op_kwargs={
            "TelemetryRecords": telemetry_records,
            "EC2InstanceId": ec2_instance_id,
            "Hostname": hostname,
            "ResourceARN": resource_arn,
        },
    )
