"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource_arn: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of tags that are applied to the specified AWS X-Ray group or sampling rule.

    Args:
        resource_arn(str): The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
        next_token(str, optional): A pagination token. If multiple pages of results are returned, use the NextToken value returned with the current page of results as the value of this parameter to get the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="list_tags_for_resource",
        op_kwargs={"ResourceARN": resource_arn, "NextToken": next_token},
    )
