"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    group_name: str = None,
    group_arn: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the AWS X-Ray SDK. Downstream services can be other applications, AWS resources, HTTP web APIs, or SQL databases.

    Args:
        start_time(str): The start of the time frame for which to generate a graph.
        end_time(str): The end of the timeframe for which to generate a graph.
        group_name(str, optional): The name of a group based on which you want to generate a graph. Defaults to None.
        group_arn(str, optional): The Amazon Resource Name (ARN) of a group based on which you want to generate a graph. Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.service_graph.get(ctx, start_time=value, end_time=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.service_graph.get start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_service_graph",
        op_kwargs={
            "StartTime": start_time,
            "EndTime": end_time,
            "GroupName": group_name,
            "GroupARN": group_arn,
            "NextToken": next_token,
        },
    )
