"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about recent sampling results for all sampling rules.

    Args:
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.sampling.statistic_summary.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.sampling.statistic_summary.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_sampling_statistic_summaries",
        op_kwargs={"NextToken": next_token},
    )
