"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, sampling_rule: Dict, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with GetSamplingRules, and evaluate each rule in ascending order of priority for each request. If a rule matches, the service records a trace, borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with GetSamplingTargets to get updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of borrowing from the reservoir.

    Args:
        sampling_rule(Dict): The rule definition.
        tags(List, optional): A map that contains one or more tag keys and tag values to attach to an X-Ray sampling rule. For more information about ways to use tags, see Tagging AWS resources in the AWS General Reference. The following restrictions apply to tags:   Maximum number of user-applied tags per resource: 50   Maximum tag key length: 128 Unicode characters   Maximum tag value length: 256 Unicode characters   Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @   Tag keys and values are case sensitive.   Don't use aws: as a prefix for keys; it's reserved for AWS use.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.sampling.rule.create(ctx, sampling_rule=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.sampling.rule.create sampling_rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="create_sampling_rule",
        op_kwargs={"SamplingRule": sampling_rule, "Tags": tags},
    )


async def delete(hub, ctx, rule_name: str = None, rule_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a sampling rule.

    Args:
        rule_name(str, optional): The name of the sampling rule. Specify a rule by either name or ARN, but not both. Defaults to None.
        rule_arn(str, optional): The ARN of the sampling rule. Specify a rule by either name or ARN, but not both. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.sampling.rule.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.sampling.rule.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="delete_sampling_rule",
        op_kwargs={"RuleName": rule_name, "RuleARN": rule_arn},
    )


async def get_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all sampling rules.

    Args:
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.sampling.rule.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.sampling.rule.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_sampling_rules",
        op_kwargs={"NextToken": next_token},
    )


async def update(hub, ctx, sampling_rule_update: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Modifies a sampling rule's configuration.

    Args:
        sampling_rule_update(Dict): The rule and fields to change.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.sampling.rule.update(ctx, sampling_rule_update=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.sampling.rule.update sampling_rule_update=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="update_sampling_rule",
        op_kwargs={"SamplingRuleUpdate": sampling_rule_update},
    )
