"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    start_time: str,
    end_time: str,
    states: List = None,
    group_arn: str = None,
    group_name: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the summaries of all insights in the specified group matching the provided filter values.

    Args:
        states(List, optional): The list of insight states. . Defaults to None.
        group_arn(str, optional): The Amazon Resource Name (ARN) of the group. Required if the GroupName isn't provided. Defaults to None.
        group_name(str, optional): The name of the group. Required if the GroupARN isn't provided. Defaults to None.
        start_time(str): The beginning of the time frame in which the insights started. The start time can't be more than 30 days old.
        end_time(str): The end of the time frame in which the insights ended. The end time can't be more than 30 days old.
        max_results(int, optional): The maximum number of results to display. Defaults to None.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.insight.summary.get_all(
                ctx, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.insight.summary.get_all start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_insight_summaries",
        op_kwargs={
            "States": states,
            "GroupARN": group_arn,
            "GroupName": group_name,
            "StartTime": start_time,
            "EndTime": end_time,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
