"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, insight_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top anomalous services, the category, the state of the insight, and the start and end time of the insight.

    Args:
        insight_id(str): The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.insight.init.get(ctx, insight_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.insight.init.get insight_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_insight",
        op_kwargs={"InsightId": insight_id},
    )
