"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, insight_id: str, start_time: str, end_time: str, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only structural information. For a complete service graph, use this API with the GetServiceGraph API.

    Args:
        insight_id(str): The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
        start_time(str): The estimated start time of the insight, in Unix time seconds. The StartTime is inclusive of the value provided and can't be more than 30 days old.
        end_time(str): The estimated end time of the insight, in Unix time seconds. The EndTime is exclusive of the value provided. The time range between the start time and end time can't be more than six hours. .
        next_token(str, optional): Specify the pagination token returned by a previous request to retrieve the next page of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.insight.impact_graph.get(
                ctx, insight_id=value, start_time=value, end_time=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.insight.impact_graph.get insight_id=value, start_time=value, end_time=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_insight_impact_graph",
        op_kwargs={
            "InsightId": insight_id,
            "StartTime": start_time,
            "EndTime": end_time,
            "NextToken": next_token,
        },
    )
