"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, insight_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event. You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.

    Args:
        insight_id(str): The insight's unique identifier. Use the GetInsightSummaries action to retrieve an InsightId.
        max_results(int, optional): Used to retrieve at most the specified value of events. Defaults to None.
        next_token(str, optional): Specify the pagination token returned by a previous request to retrieve the next page of events. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.insight.event.get_all(ctx, insight_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.insight.event.get_all insight_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_insight_events",
        op_kwargs={
            "InsightId": insight_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
