"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    group_name: str,
    filter_expression: str = None,
    insights_configuration: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a group resource with a name and a filter expression.

    Args:
        group_name(str): The case-sensitive name of the new group. Default is a reserved name and names must be unique.
        filter_expression(str, optional): The filter expression defining criteria by which to group traces. Defaults to None.
        insights_configuration(Dict, optional): The structure containing configurations related to insights.   The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable insights for the new group.   The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group. Notifications may only be enabled on a group with InsightsEnabled set to true.  . Defaults to None.
        tags(List, optional): A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information about ways to use tags, see Tagging AWS resources in the AWS General Reference. The following restrictions apply to tags:   Maximum number of user-applied tags per resource: 50   Maximum tag key length: 128 Unicode characters   Maximum tag value length: 256 Unicode characters   Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @   Tag keys and values are case sensitive.   Don't use aws: as a prefix for keys; it's reserved for AWS use.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.group.create(ctx, group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.group.create group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="create_group",
        op_kwargs={
            "GroupName": group_name,
            "FilterExpression": filter_expression,
            "InsightsConfiguration": insights_configuration,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, group_name: str = None, group_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a group resource.

    Args:
        group_name(str, optional): The case-sensitive name of the group. Defaults to None.
        group_arn(str, optional): The ARN of the group that was generated on creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.group.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.group.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="delete_group",
        op_kwargs={"GroupName": group_name, "GroupARN": group_arn},
    )


async def get(hub, ctx, group_name: str = None, group_arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves group resource details.

    Args:
        group_name(str, optional): The case-sensitive name of the group. Defaults to None.
        group_arn(str, optional): The ARN of the group that was generated on creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.group.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.group.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_group",
        op_kwargs={"GroupName": group_name, "GroupARN": group_arn},
    )


async def get_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves all active group details.

    Args:
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.group.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.group.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="get_groups",
        op_kwargs={"NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    group_name: str = None,
    group_arn: str = None,
    filter_expression: str = None,
    insights_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a group resource.

    Args:
        group_name(str, optional): The case-sensitive name of the group. Defaults to None.
        group_arn(str, optional): The ARN that was generated upon creation. Defaults to None.
        filter_expression(str, optional): The updated filter expression defining criteria by which to group traces. Defaults to None.
        insights_configuration(Dict, optional): The structure containing configurations related to insights.   The InsightsEnabled boolean can be set to true to enable insights for the group or false to disable insights for the group.   The NotifcationsEnabled boolean can be set to true to enable insights notifications for the group. Notifications can only be enabled on a group with InsightsEnabled set to true.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.group.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.group.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="update_group",
        op_kwargs={
            "GroupName": group_name,
            "GroupARN": group_arn,
            "FilterExpression": filter_expression,
            "InsightsConfiguration": insights_configuration,
        },
    )
