"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, trace_ids: List, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from a single request. Use GetTraceSummaries to get a list of trace IDs.

    Args:
        trace_ids(List): Specify the trace IDs of requests for which to retrieve segments.
        next_token(str, optional): Pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.get_trace.batch(ctx, trace_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.get_trace.batch trace_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="batch_get_traces",
        op_kwargs={"TraceIds": trace_ids, "NextToken": next_token},
    )
