"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current encryption configuration for X-Ray data.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.encryption_config.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.encryption_config.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="xray", operation="get_encryption_config", op_kwargs={}
    )


async def put(hub, ctx, type_: str, key_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the encryption configuration for X-Ray data.

    Args:
        key_id(str, optional): An AWS KMS customer master key (CMK) in one of the following formats:    Alias - The name of the key. For example, alias/MyKey.    Key ID - The KMS key ID of the key. For example, ae4aa6d49-a4d8-9df9-a475-4ff6d7898456. AWS X-Ray does not support asymmetric CMKs.    ARN - The full Amazon Resource Name of the key ID or alias. For example, arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456. Use this format to specify a key in a different account.   Omit this key if you set Type to NONE. Defaults to None.
        type_(str): The type of encryption. Set to KMS to use your own key for encryption. Set to NONE for default encryption.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.xray.encryption_config.put(ctx, type_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.xray.encryption_config.put type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="xray",
        operation="put_encryption_config",
        op_kwargs={"KeyId": key_id, "Type": type_},
    )
