"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(hub, ctx, workspace_id: str, workspace_state: str) -> Dict:
    r"""
    **Autogenerated function**

    Sets the state of the specified WorkSpace. To maintain a WorkSpace without being interrupted, set the WorkSpace state to ADMIN_MAINTENANCE. WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the ADMIN_MAINTENANCE state.

    Args:
        workspace_id(str): The identifier of the WorkSpace.
        workspace_state(str): The WorkSpace state.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.workspace.workspace.state.modify(
                ctx, workspace_id=value, workspace_state=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.workspace.workspace.state.modify workspace_id=value, workspace_state=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="workspaces",
        operation="modify_workspace_state",
        op_kwargs={"WorkspaceId": workspace_id, "WorkspaceState": workspace_state},
    )
